#
/* note			BSB	March 16,1977
 *
 * syntax:
 *	note topic [-file file] [-read] [-create] [-old]
 */

#include "/h/stat.h"
#include "/h/sgtty.h"
#include "/h/libg.h"

#define PATH "/etc/note/"

struct	{ int long0; int long1; };

char	*slist[] {
	"file",
	"read",
	"create",
	"old",
	0,
};

char	*terminators;		/* for readline() */
int	ldivr;			/* left over remainder from ldiv() */
char	*topicname;
long	topicsize;
int	topicowner;
int	nomail;
int	luid, ruid;

main(argc, argv)
char **argv;
{
	register int i;
	int readflg, createflg, oldflg;
	char *topic, *source;

	if(argc == 1)
		exit(list());
	luid = getluid();
	ruid = getruid();
	topic = source = readflg = createflg = oldflg = 0;
	for(i = 1; i < argc; i++) {
		if(*argv[i] == '-') switch(swmtch(argv[i]+1, &slist)) {

		case -2: printf("Ambiguous switch \"%s\"\n", argv[i]);
			exit(0);

		case -1: printf("Unknown switch \"%s\"\n", argv[i]);
			exit(0);

		case 0:	argchk(++i, argc);
			source = argv[i];
			continue;

		case 1:	readflg++;
			continue;

		case 2:	createflg++;
			continue;

		case 3:	oldflg++;
			readflg++;
			continue;

		} else {
			if(topic)
				error("Only one topic at a time");
			topic = argv[i];
		}
	}
	if(!topic)
		exit(type(1, "syntax: note topic [-file file][-read][-create][-old]\n"));
	if(readflg && (source || createflg))
		error("Read and Write don't mix");
	topicname = topic;
	topic = checktopic(topic);
	if((readflg || !createflg) && topicsize == 0) {
		printf("Topic \"%s\" Non-existent.\n", topicname);
		exit(0);
	}
	if(readflg)
		readtopic(topic, oldflg);
	else if(createflg)
		createtopic(topic);
	else
		appendtopic(topic, source);
}

checktopic(topic)
{
	static char topicbuffer[32];
	register char *cp;
	struct inode stbuf;

	if(any('.', topic) || any('/', topic))
		error("Illegal topic name");
	copy(topic, copy(PATH, &topicbuffer));
	if(stat(&topicbuffer, &stbuf) != -1) {
		topicsize.long0 = stbuf.i_size0;
		topicsize.long1 = stbuf.i_size1;
		topicowner = (stbuf.i_uid << 8) + (stbuf.i_gid&0377);
		nomail = stbuf.i_mode&IEXEC;
	} else {
		topicsize = 0;
		topicowner = -1;
	}
	return(&topicbuffer);
}

readtopic(topic, oldflg)
{
	register int handle, i;
	long pointer;
	char buffer[512];

	if(luid && luid != topicowner && ruid != topicowner)
		error("No read permission");
	handle = open(topic, 2);
	read(handle, &pointer, 4);
	if(pointer > topicsize)
		error("Pointer > Size");
	if(topicsize == 4l)
		return(type(1, "No entries.\n"));
	if(!oldflg && pointer == topicsize)
		return(type(1, "No new entries.\n"));
	if(!oldflg)
		lseek(handle, pointer, 0);
	while(i = read(handle, &buffer, 512))
		write(1, &buffer, i);
	seek(handle, 0, 0);
	write(handle, &topicsize, 4);
}


appendtopic(topic, source)
{
	long filesize(), size;
	char buffer[1024];
	register int i, j;
	register char *cp;
	int handle;

	handle = open(topic, 2);
	seek(handle, 0, 2);
	if(source) {
		if(filesize(source) > 512 * 10l)
			error("File limited to 10 blocks");
		if((i = open(source, 0)) < 0) {
			printf("Can't open file \"%s\"\n", source);
			return;
		}
		addheader(handle);
		while((j = read(i, &buffer, 512)) > 0)
			write(handle, &buffer, j);
		close(i);
	} else {
		if((i = open(cat(topic, ".i"), 0)) >= 0 ||
		   (i = open(cat(PATH, "default.i"), 0)) >= 0) {
			while((j = read(i, &buffer, 512)) > 0)
				write(1, &buffer, j);
			close(i);
		}
		j = gettext(0, &buffer, 1024);
		if(j > 1) {
			addheader(handle);
			write(handle, &buffer, j);
			type(1, "Noted.\n");
		} else {
			type(1, "[Not Noted]\n");
			close(handle);
			return;
		}
	}
	close(handle);
	j = getlogn(topicowner);
	cp = fmt("-t:I just added a note to \"%s\"", topicname);
	if(!(i = fork())) {
	    if(!nomail && j != -1 && !equal(j, "sys"))
		execl("/hshbin/post", "post", cp, j, "sys",  0);
	    else
		execl("/hshbin/post", "post", cp, "sys", 0);
	    exit(0);
	}
	while(wait() != i);
}


long filesize(file)
{
	struct inode st;
	long size;

	if(stat(file, &st) != -1) {
		size.long0 = st.i_size0;
		size.long1 = st.i_size1;
	} else
		size = -1l;
	return(size);
}


createtopic(topic)
{
	char owner[16];
	register int i, j;
	register char *cp;
	long s;
	int uid, mode;

	if((getpriv(luid)&PRV_SU) == 0) {
		if(luid != topicowner && ruid != topicowner)
			error("No permission to create topic");
		uid = topicowner;
	} else {
		type(1, "Owner: ");
		i = readline(0, &owner, 16);
		owner[i-1] = 0;
		if((uid = getunum(&owner)) < 0)
			error("No such logname");
	}
	mode = 0600;
	type(1, "Suppress Auto-mail(y/n)?? ");
	i = readline(0, &owner, 15);
	if(owner[0] == 'y')
		mode =| 0100;
	i = creat(topic, mode);
	chown(topic, uid);
	chmod(topic, mode);		/* in case file existed */
	s = 4l;
	write(i, &s, 4);
	close(i);
	type(1, "Created... Prompt text:\n");
	cp = gettext();
	j = length(cp);
	if(j > 1) {
		i = creat(cat(topic, ".i"), 0600);
		write(i, cp, j);
	} else
		type(1, "[Prompt not touched]");
	type(1, "[Topic created]\n");
}


list()
{
	register int i;

	type(1, "Current topics are:\n\n");
	if((i = fork()) == 0) {
		execl("/bin/ls", "ls", "-.", PATH, 0);
		exit(0);
	}
	if(i == -1)
		error("System too busy");
	while(wait() != i);
	type(1, "\nSee \"help note\" for full instructions.\n");
}


argchk(i, lim)
{
	if(i >= lim)
		error("Missing argument to switch");
}


addheader(chn)
{
	register char *cp;
	long now;

	time(&now);
	cp = ctime(&now);
	cp = fmt("\n--- From  %s   %16.16s %s\n",
		getlogn(luid), cp, cp+20);
	write(chn, cp, length(cp));
}
