/*
 * missing \n fixed by Bill Nowicki December 1981
 */

# include "mfile2"

# define TSCALAR TCHAR|TUCHAR|TSHORT|TUSHORT|TINT|TUNSIGNED|TPOINT
# define AWD SNAME|SOREG|SCON|STARNM|STARREG|SAREG
# define LWD SNAME|SOREG|SCON|SAREG
# define EA SNAME|SOREG|SCON|STARREG|SAREG|SBREG
# define EAA SNAME|SOREG|SCON|STARREG|SAREG
# define EB SBREG

static char *rcsid ="$Header: table.c,v 1.10 86/03/11 08:24:49 root Exp $";

struct optab  table[] = {

ASSIGN,	FOREFF|FORCC,
	EAA,	TSCALAR|TFLOAT,
	SZERO,	TANY,
		0,	RLEFT|RRIGHT|RESCC,	"/*001*/",
		"	clrZB	AL\n",

ASSIGN,	FOREFF|FORCC,
	EAA,	TDOUBLE,
	SZERO,	TANY,
		0,	RLEFT|RRIGHT|RESCC,	"/*002*/",
		"	clrl	AL\n	clrl	UL\n",

# ifdef SKY
ASSIGN,	FOREFF|FORCC|INAREG,
	EA,	TDOUBLE,
	EA,	TFLOAT,
		0,	RLEFT|RESCC,		"/*003*/",
		"\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAR,ZA@\n\tmovl\tZA@,AL\n\tmovl\tZA@,UL\n",

# else SKY

# ifndef IEEE

ASSIGN,	FOREFF|FORCC,
	SNAME|SOREG,	TDOUBLE,
	SNAME|SOREG,	TFLOAT,
		0,	RLEFT|RESCC,		"/*004*/",
		"	clrl	UL\n	movl	AR,AL\n",

# endif IEEE
# endif SKY

ASSIGN,	INAREG|FOREFF|FORCC,
	SAREG|STAREG,	TSCALAR,
	SCCON,	TSCALAR,
		0,	RLEFT|RRIGHT|RESCC,	"/*005*/",
		"	moveq	AR,AL\n",
# ifdef FORT
/* Prevent next template from extending constants */
ASSIGN,	FOREFF|FORCC,
	EAA,	TINT|TLONG,
	SCON,	TSHORT,
		0,	RLEFT|RRIGHT|RESCC,	"/*006*/",
		"	movZB	AR,AL\n",
/* Putting an SCONV in instead of doing this affects performance ?? */
ASSIGN,	FOREFF|FORCC,
	EAA,	TINT|TLONG,
	SAREG|STAREG,	TSHORT,
		0,	RLEFT|RRIGHT|RESCC,	"/*007*/",
		"	extl	AR\n	movZB	AR,AL\n",
# endif FORT

/* Avoid (non-existent) movb an,xxx */
ASSIGN,	FOREFF|FORCC,
	EAA,	TCHAR|TUCHAR,
	SBREG,	TSCALAR,
		NAREG,	RLEFT|RESCC,	"/*007.5*/",
		"	movl	AR,A1\n	movb	A1,AL\n",

ASSIGN,	FOREFF|FORCC,
	EAA,	TSCALAR|TFLOAT,
	EA,	TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT|RESCC,	"/*008*/",
		"	movZB	AR,AL\n",

ASSIGN,	INAREG|INBREG,
	SAREG|SBREG,	TSCALAR|TFLOAT,
	EA,	TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT|RESCC,	"/*009*/",
		"	movZB	AR,AL\n",

ASSIGN,	INAREG|INBREG,
	EAA,	TSCALAR|TFLOAT,
	SAREG|SBREG,	TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT|RESCC,	"/*010*/",
		"	movZB	AR,AL\n",

ASSIGN,	FOREFF,
	EAA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RLEFT|RRIGHT,		"/*011*/",
		"	movl	AR,AL\n	movl	UR,UL\n",

ASSIGN,	INAREG,
	SAREG,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RLEFT|RRIGHT,		"/*012*/",
		"	movl	AR,AL\n	movl	UR,UL\n",

ASSIGN,	INAREG,
	EAA,	TDOUBLE,
	SAREG,	TDOUBLE,
		0,	RLEFT|RRIGHT,		"/*013*/",
		"	movl	AR,AL\n	movl	UR,UL\n",

# ifdef SKY

ASSIGN,	FOREFF,
	EAA,	TFLOAT,
	EA,	TDOUBLE,
		0,	RLEFT|RRIGHT,		"/*014*/",
		"\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\n\tmovl\tZA@,AL\n",

# else SKY
/* I think template 3 should subsume this, but it doesn't */
# ifdef IEEE

ASSIGN,	INAREG|FOREFF,
	EAA,	TFLOAT,
	EA,	TDOUBLE,
		0,	RLEFT|RRIGHT,		"/*015*/",
		"\tmovl\tUR,Z-\n\tmovl\tAR,Z-\n\tjbsr\tdptosp\n\tmovl\td0,AL\n\taddql\t#8,sp\n",

# else IEEE

ASSIGN,	INAREG,
	EAA,	TDOUBLE,
	SAREG,	TFLOAT,
		0,	RLEFT|RRIGHT,		"/*016*/",
		"	movl	AR,AL\n	clrl	UL\n",

ASSIGN,	INAREG|FOREFF,
	EAA,	TFLOAT,
	EA,	TDOUBLE,
		0,	RLEFT|RRIGHT,		"/*017*/",
		"	movl	AR,AL\n",
# endif IEEE
# endif SKY

ASSIGN,	INBREG|FOREFF,
	EB,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT|RRIGHT|RESCC,	"/*018*/",
		"	movZB	AR,AL\n",

ASSIGN,	INBREG|FOREFF,
	EB,	TSCALAR,
	SEOREG,	TSCALAR,
		0,	RLEFT,			"/*019*/",
		"	lea	AR,AL\n",

ASSIGN, FOREFF,
	SFLD,	TANY,
	SZERO,	TANY,
		0,	RRIGHT,			"/*020*/",
		"	andY	#N,AL\n",

ASSIGN, INTAREG|INAREG|FOREFF,
	SFLD,	TANY,
	STAREG,	TANY,
		NAREG,	RRIGHT,			"/*021*/",
		"F\tmovl\tAR,sp@-\n\tmovl\t#H,A1\n\tlslY\tA1,AR\n\tandY\t#M,AR\n\tandY\t#N,AL\n\torY\tAR,AL\nF\tmovl\tsp@+,AR\n",

ASSIGN, INAREG|FOREFF,
	SFLD,	TANY,
	EA,	TANY,
		2*NAREG,	RRIGHT,		"/*022*/",
		"\tmovZB\tAR,A1\n\tmovl\t#H,A2\n\tlslY\tA2,A1\n\tandY\t#M,A1\n\tandY\t#N,AL\n\torY\tA1,AL\n",

/* put this here so UNARY MUL nodes match OPLTYPE when appropriate */
UNARY MUL,	INTAREG|INAREG|FORCC,
	SBREG,	TSCALAR,
	SANY,	TANY,
		NAREG|NASR,	RESC1|RESCC,	"/*023*/",
		"	movZB	AL@,A1\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	EAA,	TSCALAR,
		0,	RESCC,			"/*024*/",
		"	tstZB	AR\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	EB,	TSCALAR,
		NAREG,	RESCC,			"/*025*/",
		"	movZB	AR,A1\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	EB,	TSCALAR,
		0,	RESCC,			"/*026*/",
		"	cmpZB	#0,AR\n",

OPLTYPE,	INTAREG|INAREG|FORCC,
	SANY,	TANY,
	SZERO,	TSCALAR,
		NAREG|NASR,	RESC1|RESCC,	"/*027*/",
		"	clrZB	A1\n",

OPLTYPE,	INTAREG|INAREG|FORCC,
	SANY,	TANY,
	SCCON,	TSCALAR,
		NAREG|NASR,	RESC1|RESCC,	"/*028*/",
		"	moveq	AR,A1\n",

OPLTYPE,	INTAREG|INAREG|FORCC,
	SANY,	TANY,
	EA,	TSCALAR,
		NAREG|NASR,	RESC1|RESCC,	"/*029*/",
		"	movZB	AR,A1\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TDOUBLE,
		NAREG|NASR,	RESC1,		"/*030*/",
		"	movl	AR,A1\n	movl	UR,U1\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TFLOAT,
		NAREG|NASR,	RESC1,		"/*031*/",
		"	movl	AR,A1\n",

OPLTYPE,	INTBREG|INBREG|FORCC,
	SANY,	TANY,
	EA,	TSCALAR,
		NBREG|NBSR,	RESC1|RESCC,	"/*032*/",
		"	movZB	AR,A1\n",

OPLTYPE,	INTEMP|FORCC,
	SANY,	TANY,
	EA,	TSCALAR,
		NTEMP,	RESC1|RESCC,		"/*033*/",
		"	movZB	AR,A1\n",

OPLTYPE,	INTEMP|FORCC,
	SANY,	TANY,
	EA,	TDOUBLE,
		2*NTEMP,	RESC1|RESCC,	"/*034*/",
		"	movl	UR,U1\n	movl	AR,A1\n",

OPLTYPE,	INTEMP|FORCC,
	SANY,	TANY,
	EA,	TFLOAT,
		NTEMP,	RESC1|RESCC,		"/*035*/",
		"	movl	AR,A1\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SBREG,	TINT|TUNSIGNED|TPOINT,
		0,	RNULL,			"/*036*/",
		"	pea	AR@\nZP",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SICON,	TSCALAR,
		0,	RNULL,			"/*037*/",
		"	pea	CR\nZP",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SCCON,	TSCALAR,
		NAREG,	RNULL,			"/*038*/",
		"	moveq	AR,A1\n	movl	A1,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TINT|TUNSIGNED|TPOINT,
		0,	RNULL,			"/*039*/",
		"	movl	AR,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SAREG|STAREG,	TSHORT,
		0,	RNULL,			"/*040*/",
		"	extl	AR\n	movl	AR,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TSHORT,
		NBREG|NBSR,	RNULL,		"/*041*/",
		"	movw	AR,A1\n	movl	A1,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SAREG|STAREG,	TUSHORT,
		0,	RNULL,			"/*042*/",
		"	andl	#0xffff,AR\n	movl	AR,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TUSHORT,
		0,	RNULL,			"/*043*/",
		"	movw	AR,sp@-\n	clrw	Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SAREG|STAREG,	TCHAR,
		0,	RNULL,			"/*044*/",
		"	extw	AR\n	extl	AR\n	movl	AR,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TCHAR,
		NAREG|NASR,	RNULL,		"/*045*/",
		"	movb	AR,A1\n	extw	A1\n	extl	A1\n	movl	A1,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SAREG|STAREG,	TUCHAR,
		0,	RNULL,			"/*046*/",
		"	andl	#0xff,AR\n	movl	AR,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TUCHAR,
		NAREG,	RNULL,			"/*047*/",
		"	moveq	#0,A1\n	movb	AR,A1\n	movl	A1,Z-\n",

# ifdef SKY
OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TFLOAT,
		NAREG|NASR,	RNULL,		"/*048*/",
		"\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\n\tmovl\tA1,Z-\n",

# else SKY
# ifdef IEEE
OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TFLOAT,
		0,	RNULL,			"/*049*/",
		"	movl	AR,Z-\n",
# else IEEE
OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TFLOAT,
		0,	RNULL,			"/*050*/",
		"	clrl	Z-\n	movl	AR,Z-\n",
# endif IEEE
# endif SKY

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TDOUBLE,
		0,	RNULL,			"/*051*/",
		"	movl	UR,Z-\n	movl	AR,Z-\nZD",

OPLOG,	FORCC,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCCON,	TSCALAR,
		NAREG,	RESCC,			"/*051*/",
		"	moveq	AR,A1\n	cmpZB	AL,A1\nZF",

OPLOG,	FORCC,
	SAREG|STAREG|SBREG|STBREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RESCC,			"/*053*/",
		"	cmpZB	AR,AL\nZI",

OPLOG,	FORCC,
	SNAME|SOREG|SAREG|STAREG,	TSCALAR,
	SCON,	TSCALAR,
		0,	RESCC,			"/*054*/",
		"	cmpZB	AR,AL\nZI",

# ifdef SKY
OPLOG,	FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RESCC,			"/*055*/",
/* For now, we'll ignore the potential use of the returned bit 5 */
		"\tmovw\t#0x105e,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\n\tmovw\tZA@,cc\nZI",

# ifdef FORT
OPLOG,	FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		0,	RESCC,			"/*056*/",
		"\tmovw\t#0x105d,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovw\tZA@,cc\nZI",
# endif FORT

# else SKY

# ifdef IEEE
OPLOG,	FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RESCC,			"/*057*/",
		"\tmovl\tUR,Z-\n\tmovl\tAR,Z-\n\tmovl\tUL,Z-\n\tmovl\tAL,Z-\n\tjbsr\tdpcmp\n\tlea\tsp@(0x10),sp\nZI",

# ifdef FORT
OPLOG,	FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		0,	RESCC,			"/*058*/",
		"\tmovl\tAR,Z-\n\tmovl\tAL,Z-\n\tjbsr\tspcmp\n\tlea\tsp@(0x8),sp\nZI",
# else FORT
/* Let's try to cause an error here until we implement this template */
# endif FORT
# else IEEE
/* Note: The fpcmp routine resets sp itself. This is OK, but not consistent */
/* with other software fp routines */
OPLOG,	FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RESCC,			"/*059*/",
		"\tmovl\tUR,Z-\n\tmovl\tAR,Z-\n\tmovl\tUL,Z-\n\tmovl\tAL,Z-\n\tjbsr\tfcmp\nZI",

# ifdef FORT
OPLOG,	FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		0,	RESCC,			"/*060*/",
		"\tclrl\tZ-\n\tmovl\tAR,Z-\n\tclrl\tZ-\n\tmovl\tAL,Z-\n\tjbsr\tfcmp\nZI",
# endif FORT
# endif IEEE

# endif SKY

BTST,	FORCC,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCON,	TSCALAR,
		0,	RESCC,			"/*061*/",
		"	btst	AR,AL\n",

CCODES,	INTAREG|INAREG,
	SANY,	TANY,
	SANY,	TANY,
		NAREG,	RESC1,			"/*062*/",
		"	moveq	#1,A1\nZN",

UNARY MINUS,	INTAREG|INAREG,
	STAREG,	TSCALAR,
	SANY,	TANY,
		0,	RLEFT,			"/*063*/",
		"	negZB	AL\n",

# ifdef IEEE
UNARY MINUS,	INTAREG|INAREG|FOREFF,
	STAREG,	TFLOAT|TDOUBLE,
	SANY,	TANY,
		0,	RLEFT,			"/*064*/",
		"	bchg	#31,AL\n",
# endif IEEE

COMPL,	INTAREG|INAREG,
	STAREG,	TSCALAR,
	SANY,	TANY,
		0,	RLEFT,			"/*065*/",
		"	notZB	AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		NAREG,	RESC1,			"/*066*/",
		"F	movZB	AL,A1\n	addqZB	AR,AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		NAREG,	RESC1,			"/*067*/",
		"F	movZB	AL,A1\n	subqZB	AR,AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		NAREG,	RESC1,			"/*068*/",
		"F	movZB	AL,A1\n	addZB	AR,AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		NAREG,	RESC1,			"/*069*/",
		"F	movZB	AL,A1\n	subZB	AR,AL\n",

INCR,	INTBREG|INBREG|FOREFF,
	EA,	TSCALAR,
	S8CON,	TSCALAR,
		NBREG,	RESC1,			"/*070*/",
		"F	movZB	AL,A1\n	addqZB	AR,AL\n",

DECR,	INTBREG|INBREG|FOREFF,
	EA,	TSCALAR,
	S8CON,	TSCALAR,
		NBREG,	RESC1,			"/*071*/",
		"F	movZB	AL,A1\n	subqZB	AR,AL\n",

INCR,	INTBREG|INBREG|FOREFF,
	EA,	TSCALAR,
	SCON,	TSCALAR,
		NBREG,	RESC1,			"/*072*/",
		"F	movZB	AL,A1\n	addZB	AR,AL\n",

DECR,	INTBREG|INBREG|FOREFF,
	EA,	TSCALAR,
	SCON,	TSCALAR,
		NBREG,	RESC1,			"/*073*/",
		"F	movZB	AL,A1\n	subZB	AR,AL\n",

# ifndef SKY
INCR,	INTAREG|INAREG|FOREFF,
	EAA,	TFLOAT,
	SANY,	TANY,
		NTEMP,	RESC1,		"/*074*/",
		"ZH",

DECR,	INTAREG|INAREG|FOREFF,
	EAA,	TFLOAT,
	SANY,	TANY,
		NTEMP,	RESC1,		"/*075*/",
		"ZH",

INCR,	INTAREG|INAREG|FOREFF,
	EAA,	TDOUBLE,
	SANY,	TANY,
		2*NTEMP,	RESC1,		"/*076*/",
		"ZH",

DECR,	INTAREG|INAREG|FOREFF,
	EAA,	TDOUBLE,
	SANY,	TANY,
		2*NTEMP,	RESC1,		"/*077*/",
		"ZH",
# endif SKY

PLUS,		INBREG|INTBREG,
	SBREG,	TPOINT,
	SSCON,	TANY,
		NBREG|NBSL,	RESC1,		"/*078*/",
		"	lea	AL@ZO,A1\n",

PLUS,		FORARG,
	SBREG,	TPOINT,
	SSCON,	TANY,
		0,	RNULL,			"/*079*/",
		"	pea	AL@ZO\nZP",

MINUS,		INBREG|INTBREG,
	SBREG,	TPOINT,
	SSCON,	TANY,
		NBREG|NBSL,	RESC1,		"/*080*/",
		"	lea	AL@ZM,A1\n",

MINUS,		FORARG,
	SBREG,	TPOINT,
	SSCON,	TANY,
		0,	RNULL,			"/*081*/",
		"	pea	AL@ZM\nZP",

ASG PLUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,		"/*082*/",
		"	addqZB	AR,AL\n",

ASG PLUS,	INBREG,
	EB,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT,			"/*083*/",
		"	addqZB	AR,AL\n",

ASG PLUS,	INAREG|FORCC,
	EAA,	TINT|TUNSIGNED|TPOINT,
	SCCON,	TSCALAR,
		NAREG,	RLEFT|RESCC,		"/*084*/",
		"	moveq	AR,A1\n	addZB	A1,AL\n",

ASG PLUS,	INAREG|FORCC,
	SAREG|STAREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT|RESCC,		"/*085*/",
		"	addZB	AR,AL\n",

ASG PLUS,	INAREG|INBREG,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCCON,	TSCALAR,
		NAREG,	RLEFT,			"/*086*/",
		"	moveq	AR,A1\n	addZB	A1,AL\n",

ASG PLUS,	INBREG,
	SBREG|STBREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT,			"/*087*/",
		"	addZB	AR,AL\n",

ASG PLUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,		"/*088*/",
		"	addZB	AR,AL\n",

# ifdef SKY

PLUS,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		NAREG,	RESC1|RESCC,		"/*089*/",
		"\tmovw\t#0x1002,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n",

PLUS,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		NAREG,	RESC1|RESCC,		"/*090*/",
		"\tmovw\t#0x1001,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,A1\n",

ASG PLUS,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RLEFT|RESCC,		"/*091*/",
		"\tmovw\t#0x1002,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\n\tmovl\tZA@,AL\n\tmovl\tZA@,UL\n",

ASG PLUS,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		0,	RLEFT|RESCC,		"/*092*/",
		"\tmovw\t#0x1001,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,AL\n",


/* I hate this template!!! */
/* Unfortunately, the single-to-double-sum instruction seems broken */
/* It would be nice if Sky would do in-register sp to dp and back */
/* Note that the AREG gotten here is size float, not double, so don't try */
/* to use U1 -- it may overlap AR.  Fortunately, we can use AL for scratch */

ASG PLUS,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TDOUBLE,
		NAREG,	RLEFT|RESCC,	"/*093*/",
		"\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x1004,ZA@(-4)\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tAL,ZA@\n\tmovl\tZA@,AL\n",

# endif SKY

ASG MINUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,		"/*094*/",
		"	subqZB	AR,AL\n",

ASG MINUS,	INBREG,
	EB,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT,			"/*095*/",
		"	subqZB	AR,AL\n",

ASG MINUS,	INAREG|FORCC,
	EAA,	TINT|TUNSIGNED|TPOINT,
	SCCON,	TSCALAR,
		NAREG,	RLEFT|RESCC,		"/*096*/",
		"	moveq	AR,A1\n	subZB	A1,AL\n",


ASG MINUS,	INAREG|FORCC,
	SAREG|STAREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT|RESCC,		"/*097*/",
		"	subZB	AR,AL\n",

ASG MINUS,	INAREG|INBREG,
	EA,	TINT|TUNSIGNED|TPOINT,
	SCCON,	TSCALAR,
		NAREG,	RLEFT,			"/*098*/",
		"	moveq	AR,A1\n	subZB	A1,AL\n",


ASG MINUS,	INBREG,
	SBREG|STBREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT,			"/*099*/",
		"	subZB	AR,AL\n",

ASG MINUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,		"/*100*/",
		"	subZB	AR,AL\n",

# ifdef SKY

/* NOTE - the wait here IS required */
MINUS,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		NAREG,	RESC1|RESCC,		"/*101*/",
		"\tmovw\t#0x1008,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n",

/* NOTE - the wait here IS required */
MINUS,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		NAREG,	RESC1|RESCC,		"/*102*/",
		"\tmovw\t#0x1007,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,A1\n",

/* NOTE - the wait here IS required */
ASG MINUS,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RLEFT|RESCC,		"/*103*/",
		"\tmovw\t#0x1008,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,AL\n\tmovl\tZA@,UL\n",

/* NOTE - the wait here IS required */
ASG MINUS,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		0,	RLEFT|RESCC,		"/*104*/",
		"\tmovw\t#0x1007,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,AL\n",


/* Yep, I hate this one, too. */
/* Some of this should probably have been handled by inserting SCONVs */
/* Note that the AREG gotten here is size float, not double, so don't try */
/* to use U1 -- it may overlap AR.  Fortunately, we can use AL for scratch */

ASG MINUS,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TDOUBLE,
		NAREG,	RLEFT|RESCC,	"/*105*/",
		"\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x100a,ZA@(-4)\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\n\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tAL,ZA@\n\tmovl\tZA@,AL\n",

# endif SKY


ASG ER, 	INAREG|FORCC,
	EAA,	TINT|TUNSIGNED|TPOINT,
	SCCON,	TSCALAR,
		NAREG,	RLEFT|RESCC,		"/*106*/",
		"	moveq	AR,A1\n	eorZB	A1,AL\n",


ASG ER, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		0,	RLEFT|RESCC,		"/*107*/",
		"	eorZB	AR,AL\n",

ASG ER, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,		"/*108*/",
		"	eorZB	AR,AL\n",

ASG OPSIMP, 	INAREG|FORCC,
	EAA,	TINT|TUNSIGNED|TPOINT,
	SCCON,	TSCALAR,
		NAREG,	RLEFT|RESCC,		"/*109*/",
		"	moveq	AR,A1\n	OIZB	A1,AL\n",

ASG OPSIMP, 	INAREG|FORCC,
	SAREG|STAREG,	TSCALAR,
	EAA,	TSCALAR,
		0,	RLEFT|RESCC,		"/*110*/",
		"	OIZB	AR,AL\n",

ASG OPSIMP, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		0,	RLEFT|RESCC,		"/*111*/",
		"	OIZB	AR,AL\n",

ASG OPSIMP, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,		"/*112*/",
		"	OIZB	AR,AL\n",

ASG MUL,	INAREG|FORCC,
	SAREG,	TUNSIGNED|TINT,
	SCON,	TUNSIGNED|TINT,
		NAREG,	RLEFT|RESCC,		"/*113*/",
		"Zm",

# ifdef NFSKY

/*	SNAME|.... is EA except for SCON.  Don't want to override mulshift */
MUL,	INAREG|FORCC,
	EA,	TINT,
	SNAME|SOREG|STARREG|SAREG|SBREG,	TINT,
		NAREG,	RESC1|RESCC,		"/*114*/",
		"Zu\tmovw\t#0x1046,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,A1\n",

MUL,	INAREG|FORCC,
	EA,	TUNSIGNED|TINT,
	SNAME|SOREG|STARREG|SAREG|SBREG,	TUNSIGNED|TINT,
		NAREG,	RESC1|RESCC,		"/*115*/",
		"Zu\tmovw\t#0x1062,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,A1\n",

ASG MUL,	INAREG|FORCC,
	EA,	TINT,
	EA,	TINT,
		0,	RLEFT|RESCC,		"/*116*/",
		"Zu\tmovw\t#0x1046,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,AL\n",

ASG MUL,	INAREG|FORCC,
	EA,	TUNSIGNED|TINT,
	EA,	TUNSIGNED|TINT,
		0,	RLEFT|RESCC,		"/*117*/",
		"Zu\tmovw\t#0x1062,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,AL\n",

# else NFSKY

ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TINT,
	SAREG|STAREG,	TINT,
		0,	RLEFT|RESCC,			"/*118*/",
		"\tjsr\trlmul\nD\ttstl\td0\n",

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TINT,
	SAREG|STAREG,	TINT,
		0,	RLEFT|RESCC,			"/*119*/",
		"\tjsr\trldiv\nD\ttstl\td0\n",

ASG MOD,	INAREG|FORCC,
	SAREG|STAREG,	TINT,
	SAREG|STAREG,	TINT,
		0,	RLEFT|RESCC,			"/*120*/",
		"\tjsr\trlrem\nD\ttstl\td0\n",

/* NOTE: the corresponding TINT templates must come before these */

ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TINT|TUNSIGNED,
	SAREG|STAREG,	TINT|TUNSIGNED,
		0,	RLEFT|RESCC,			"/*121*/",
		"\tjsr\trulmul\nD\ttstl\td0\n",

ASG DIV,	INAREG|FORCC,
	STAREG,	TINT|TUNSIGNED,
	STAREG,	TINT|TUNSIGNED,
		0,	RLEFT|RESCC,			"/*122*/",
		"\tjsr\truldiv\nD\ttstl\td0\n",

ASG MOD,	INAREG|FORCC,
	STAREG,	TINT|TUNSIGNED,
	STAREG,	TINT|TUNSIGNED,
		0,	RLEFT|RESCC,			"/*123*/",
		"\tjsr\trulrem\nD\ttstl\td0\n",

# endif NFSKY


ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TSHORT,
		0,	RLEFT|RESCC,		"/*124*/",
		"	muls	AR,AL\n",

ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TUSHORT,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT|RESCC,		"/*125*/",
		"	mulu	AR,AL\n",

ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TUSHORT,
		0,	RLEFT|RESCC,		"/*126*/",
		"	mulu	AR,AL\n",


ASG MUL,	INAREG,
	SAREG|STAREG,	TCHAR,
	EAA,	TCHAR,
		NAREG|NASR,	RLEFT,		"/*127*/",
		"\textw	AL\n\tmovb	AR,A1\n\textw	A1\n\tmuls	A1,AL\n",

ASG MUL,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG,	RLEFT,			"/*128*/",
		"\tandw	#255,AL\n\tclrw	A1\n\tmovb	AR,A1\n\tmuls	A1,AL\n",

ASG MUL,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG|NASR,	RLEFT,		"/*129*/",
		"\tandw	#255,AL\n\tmovb	AR,A1\n\tandw	#255,A1\n\tmuls	A1,AL\n",

# ifdef SKY

MUL,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		NAREG,	RESC1|RESCC,		"/*130*/",
		"\tmovw\t#0x100c,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n",

MUL,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		NAREG,	RESC1|RESCC,		"/*131*/",
		"\tmovw\t#0x100b,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,A1\n",

ASG MUL,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RLEFT|RESCC,		"/*132*/",
		"\tmovw\t#0x100c,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,AL\n\tmovl\tZA@,UL\n",

ASG MUL,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		0,	RLEFT|RESCC,		"/*133*/",
		"\tmovw\t#0x100b,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,AL\n",

/* Yep, I hate this one, too. */
/* Some of this should probably have been handled by inserting SCONVs */
/* Note that the AREG gotten here is size float, not double, so don't try */
/* to use U1 -- it may overlap AR.  Fortunately, we can use AL for scratch */

ASG MUL,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TDOUBLE,
		NAREG,	RLEFT|RESCC,	"/*134*/",
		"\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x100e,ZA@(-4)\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tAL,ZA@\n\tmovl\tZA@,AL\n",

# endif SKY

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TINT,
	EAA,	TSHORT,
		0,	RLEFT|RESCC,		"/*135*/",
		"	divs	AR,AL\n	extl	AL\n",

/* There seems to be a problem with the compiler not putting conversions */
/* over these divides.  This is not the right way to deal with it, but.... */
ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TSHORT,
		0,	RLEFT|RESCC,		"/*136*/",
		"	extl	AL\n	divs	AR,AL\n	extl	AL\n",

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TUNSIGNED,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT|RESCC,		"/*137*/",
		"	divu	AR,AL\n\tswap\tAL\n\tclrw\tAL\n\tswap\tAL\n",

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TUSHORT,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT|RESCC,		"/*138*/",
		"\tandl\t#0xffff,AL\n\tdivu\tAR,AL\n\tandl\t#0xffff,AL\n",

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TUSHORT,
		0,	RLEFT|RESCC,		"/*139*/",
		"	extl	AL\n	divu	AR,AL\n	extl	AL\n",

# ifdef NFSKY
DIV,	INAREG|FORCC,
	EA,	TINT,
	EA,	TINT,
		NAREG,	RESC1|RESCC,		"/*140*/",
		"Zu\tmovw\t#0x1061,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,A1\n",

DIV,	INAREG|FORCC,
	EA,	TUNSIGNED|TINT,
	EA,	TUNSIGNED|TINT,
		NAREG,	RESC1|RESCC,		"/*141*/",
		"Zu\tmovw\t#0x103d,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,A1\n",

ASG DIV,	INAREG|FORCC,
	EA,	TINT,
	EA,	TINT,
		0,	RLEFT|RESCC,		"/*142*/",
		"Zu\tmovw\t#0x1061,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,AL\n",

ASG DIV,	INAREG|FORCC,
	EA,	TUNSIGNED|TINT,
	EA,	TUNSIGNED|TINT,
		0,	RLEFT|RESCC,		"/*143*/",
		"Zu\tmovw\t#0x103d,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,AL\n",
# endif NFSKY

ASG DIV,	INAREG,
	SAREG|STAREG,	TCHAR,
	EAA,	TCHAR,
		NAREG|NASR,	RLEFT,		"/*144*/",
		"\textw AL\n\textl	AL\n\tmovb	AR,A1\n\textw	A1\n\tdivs	A1,AL\n	extl	AL\n",

ASG DIV,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG,	RLEFT,			"/*145*/",
		"\tandl	#255,AL\n\tclrw	A1\n\tmovb\tAR,A1\n\tdivs\tA1,AL\n\tandl\t#255,AL\n",

ASG DIV,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG|NASR,	RLEFT,		"/*146*/",
		"\tandl	#255,AL\n\tmovb	AR,A1\n\tandw\t#255,A1\n\tdivs\tA1,AL\n\tandl#255,AL\n",

# ifdef SKY

DIV,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		NAREG,	RESC1|RESCC,		"/*147*/",
		"\tmovw\t#0x1014,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n",

DIV,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		NAREG,	RESC1|RESCC,		"/*148*/",
		"\tmovw\t#0x1013,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,A1\n",

ASG DIV,	INAREG|FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RLEFT|RESCC,		"/*149*/",
		"\tmovw\t#0x1014,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,AL\n\tmovl\tZA@,UL\n",

ASG DIV,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TFLOAT,
		0,	RLEFT|RESCC,		"/*150*/",
		"\tmovw\t#0x1013,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,AL\n",

/* Yep, I hate this one, too. */
/* Some of this should probably have been handled by inserting SCONVs */
/* Note that the AREG gotten here is size float, not double, so don't try */
/* to use U1 -- it may overlap AR.  Fortunately, we can use AL for scratch */

ASG DIV,	INAREG|FORCC,
	EA,	TFLOAT,
	EA,	TDOUBLE,
		NAREG,	RLEFT|RESCC,	"/*151*/",
		"\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x1016,ZA@(-4)\n\tmovl\tAR,ZA@\n\tmovl\tUR,ZA@\nZL\tmovl\tZA@,A1\n\tmovl\tZA@,AL\n\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tAL,ZA@\n\tmovl\tZA@,AL\n",

# endif SKY

/*  Is the extl here really correct?  -WT- */
ASG MOD,	INAREG|FORCC,
	SAREG|STAREG,	TINT,
	EAA,	TSHORT,
		0,	RLEFT|RESCC,			"/*152*/",
		"	divs	AR,AL\n	swap	AL\n	extl	AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TUNSIGNED,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT,			"/*153*/",
		"	divu	AR,AL\n	clrw	AL\n	swap	AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TSHORT,
	EAA,	TSHORT,
		0,	RLEFT,			"/*154*/",
		"	extl	AL\n	divs	AR,AL\n	swap	AL\n",

/* Could do swap, clrw, swap instead of andl here, but would make pretty */
/* long (though faster) sequence of instructions.  -WT- */
ASG MOD,	INAREG,
	SAREG|STAREG,	TUSHORT,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT,			"/*155*/",
		"	andl	#0xffff,AL\n	divu	AR,AL\n	swap	AL\n	andl	#0xffff,AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TSHORT,
	EAA,	TUSHORT,
		0,	RLEFT,			"/*156*/",
		"	andl	#65535,AL\n	divu	AR,AL\n	swap	AL\n",

# ifdef NFSKY
/*
**	These templates may be bypassed by code in local2.c
*/
MOD,	INAREG|FORCC,
	EA,	TINT,
	EA,	TINT,
		NAREG,	RESC1|RESCC,		"/*157*/",
		"Zu\tmovw\t#0x1064,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,A1\n",

MOD,	INAREG|FORCC,
	EA,	TUNSIGNED|TINT,
	EA,	TUNSIGNED|TINT,
		NAREG,	RESC1|RESCC,		"/*158*/",
		"Zu\tmovw\t#0x1066,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,A1\n",

ASG MOD,	INAREG|FORCC,
	EA,	TINT,
	EA,	TINT,
		0,	RLEFT|RESCC,		"/*159*/",
		"Zu\tmovw\t#0x1064,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\nZL\tmovl\tZA@,AL\n",

ASG MOD,	INAREG|FORCC,
	EA,	TUNSIGNED|TINT,
	EA,	TUNSIGNED|TINT,
		0,	RLEFT|RESCC,		"/*160*/",
		"Zu\tmovw\t#0x1066,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,AL\n",
# endif NFSKY

/*
**	It is my opinion that the extw below ought to be OK in the share right
**	case.  I certainly hope my opinion is correct -WT-
*/
ASG MOD,	INAREG,
	SAREG|STAREG,	TCHAR,
	EAA,	TCHAR,
		NAREG|NASR,	RLEFT,		"/*161*/",
		"\textw\tAL\n\textl\tAL\n\tmovb\tAR,A1\n\textw\tA1\n\tdivs\tA1,AL\n\tswap\tAL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG,	RLEFT,			"/*162*/",
		"\tandl	#255,AL\n\tclrw	A1\n\tmovb	AR,A1\n\tdivs	A1,AL\n	swap	AL\n",

/*
**	I also hope the andw with A1 is OK here in the share case.
*/
ASG MOD,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG|NASR,	RLEFT,		"/*163*/",
		"\tandl\t#255,AL\n\tmovb\tAR,A1\n\tandw\t#255,A1\n\tdivs\tA1,AL\n\tswap\tAL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TINT|TSHORT|TCHAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,		"/*164*/",
		"	aOIZB	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SNAME|SOREG,	TSHORT,
	SONE,	TSCALAR,
		0,	RLEFT|RESCC,		"/*165*/",
		"	aOIw	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TINT|TSHORT|TCHAR,
	SAREG,	TSCALAR,
		0,	RLEFT|RESCC,		"/*166*/",
		"	aOIZB	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TUNSIGNED|TUSHORT|TUCHAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,		"/*167*/",
		"	lOIZB	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	EA,	TUSHORT,
	SONE,	TSCALAR,
		0,	RLEFT|RESCC,		"/*168*/",
		"	lOIw	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TUNSIGNED|TUSHORT|TUCHAR,
	SAREG,	TSCALAR,
		0,	RLEFT|RESCC,		"/*169*/",
		"	lOIZB	AR,AL\n",

UNARY CALL,	INTAREG,
	SBREG|SNAME|SOREG|SCON,	TANY,
	SANY,	TANY,
		/* should be register 0 */
		NAREG|NASL,	RESC1,		"/*170*/",
		"ZC\n",

# ifdef FORT
GOTO ,	FOREFF,
	SBREG|SNAME|SOREG|SCON,	TANY,
	SANY,	TANY,
		/* should be register 0 */
		NAREG|NASL,	RNULL, 		"/*171*/",
		"ZG\n",
# endif FORT

SCONV,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TINT|TUNSIGNED|TPOINT,
	SANY,	TCHAR|TUCHAR|TSHORT|TUSHORT|TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,			"/*172*/",
		"",

SCONV,	INBREG,
	SBREG|STBREG,	TINT|TUNSIGNED|TPOINT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,			"/*173*/",
		"",

SCONV,	INBREG|INTBREG,
	EAA|STAREG,	TINT|TUNSIGNED|TPOINT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NBREG,	RESC1,			"/*174*/",
		"	movl	AL,A1\n",

SCONV,	FORCC,
	SAREG|STAREG,	TINT|TUNSIGNED|TPOINT,
	SANY,	TCHAR|TUCHAR|TSHORT|TUSHORT|TINT|TUNSIGNED|TPOINT,
		0,	RESCC,			"/*175*/",
		"	tstZB	AL\n",

SCONV,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSHORT|TUSHORT,
	SANY,	TCHAR|TUCHAR|TSHORT|TUSHORT,
		0,	RLEFT,			"/*176*/",
		"",

SCONV,	FORCC,
	SAREG|STAREG,	TSHORT|TUSHORT,
	SANY,	TCHAR|TUCHAR|TSHORT|TUSHORT,
		0,	RESCC,			"/*177*/",
		"	tstZB	AL\n",

SCONV,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TCHAR|TUCHAR,
	SANY,	TCHAR|TUCHAR,
		0,	RLEFT,			"/*178*/",
		"",

SCONV,	FORCC,
	SAREG|STAREG,	TCHAR|TUCHAR,
	SANY,	TCHAR|TUCHAR,
		0,	RESCC,			"/*179*/",
		"	tstZB	AL\n",

SCONV,	INAREG|FOREFF|FORCC,
	STAREG,	TCHAR,
	SANY,	TSHORT|TUSHORT,
		0,	RLEFT|RESCC,		"/*180*/",
		"	extw	AL\n",

SCONV,	INAREG|FOREFF|FORCC,
	SAREG,	TCHAR,
	SANY,	TSHORT|TUSHORT,
		NAREG,	RESC1|RESCC,		"/*181*/",
		"	movw	AL,A1\n	extw	A1\n",

SCONV,	INTAREG,
	STAREG,	TCHAR,
	SANY,	TSHORT|TUSHORT,
		0,	RLEFT,			"/*182*/",
		"	extw	AL\n",

SCONV,	INAREG|FOREFF|FORCC,
	STAREG,	TCHAR,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,		"/*183*/",
		"	extw	AL\n	extl	AL\n",

SCONV,	INAREG|FOREFF|FORCC,
	SAREG,	TCHAR,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RESC1|RESCC,		"/*184*/",
		"	movb	AL,A1\n	extw	A1\n	extl	A1\n",

SCONV,	INTAREG,
	STAREG,	TCHAR,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,			"/*185*/",
		"	extw	AL\n	extl	AL\n",

SCONV,	INBREG,
	STAREG,	TCHAR,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NBREG,	RESC1,			"/*186*/",
		"	extw	AL\n	movw	AL,A1\n",

SCONV,	INAREG|INTAREG|FOREFF|FORCC,
	STAREG,	TSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,		"/*187*/",
		"	extl	AL\n",

SCONV,	INAREG|FOREFF|FORCC,
	EAA|SAREG,	TSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NAREG,	RESC1|RESCC,		"/*188*/",
		"	movw	AL,A1\n	extl	A1\n",

/* 189 deleted: WAT */

SCONV,	INBREG,
	EAA|STAREG,	TSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NBREG,	RESC1,			"/*190*/",
		"	movw	AL,A1\n",

SCONV,	INAREG|FOREFF|FORCC,
	SAREG|STAREG,	TUCHAR,
	SANY,	TSCALAR,
		0,	RLEFT|RESCC,		"/*191*/",
/*		"F	andl	#0xff,AL\n", /* */
		"	andl	#0xff,AL\n",

SCONV,	INTAREG,
	STAREG,	TUCHAR,
	SANY,	TSCALAR,
		0,	RLEFT,			"/*192*/",
		"	andl	#0xff,AL\n",

SCONV,	INBREG,
	STAREG,	TUCHAR,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NBREG,	RESC1,			"/*193*/",
		"	andl	#0xff,AL\n	movl	AL,A1\n",

SCONV,	INAREG|FOREFF|FORCC,
	SAREG|STAREG,	TUSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT|RESCC,		"/*194*/",
/*		"F	andl	#0xffff,AL\n", /* */
		"	andl	#0xffff,AL\n",

SCONV,	INTAREG,
	STAREG,	TUSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,			"/*195*/",
		"	andl	#0xffff,AL\n",

SCONV,	INBREG,
	STAREG,	TUSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		NBREG,	RESC1,			"/*196*/",
		"	andl	#0xffff,AL\n	movl	AL,A1\n",

SCONV,	INAREG|FOREFF,
	SNAME|SOREG|SCON|SAREG,	TINT|TUNSIGNED|TPOINT|TSHORT|TUSHORT,
	SANY,	TSHORT|TUSHORT|TCHAR|TUCHAR,
		0,	RLEFT,			"/*197*/",
		"ZT",

SCONV,	INAREG|FOREFF,
	SNAME|SOREG|SCON|SAREG|SBREG,	TINT|TUNSIGNED|TPOINT|TSHORT|TUSHORT,
	SANY,	TSHORT|TUSHORT,
		0,	RLEFT,			"/*198*/",
		"ZT",

# ifdef SKY	/***********************************************************/
SCONV,	INAREG|INTAREG,
	EA,	TDOUBLE,
	SANY,	TFLOAT,
		NAREG|NASL,	RESC1,		"/*199*/",
		"\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tZA@,A1\n",

/*
**	I don't really see why the next template is necessary, given the one
**	that follows, but I don't want to remove it until checking things in,
**	as I know that the compiler works with it here. -WT-
*/
SCONV,	FORARG,
	EA,	TANY,
	SANY,	TANY,
		NAREG,	RNULL,			"/*200*/",
		"ZV",

SCONV,	FORARG,
	SANY,	TANY,
	SANY,	TANY,
		NAREG,	RNULL,			"/*201*/",
		"ZV",

SCONV,	INAREG|INTAREG,
	EA,	TFLOAT,
	SANY,	TDOUBLE,
		NAREG|NASL,	RESC1,		"/*202*/",
		"\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n",

/*
** This template is a somewhat inelegant way to deal with the compiler's 
** overzealous use of type conversions.
*/
SCONV,	INAREG|INTAREG,
	EA,	TDOUBLE,
	SANY,	TDOUBLE,
		0,	RLEFT,			"/*203*/",
		"",

/*
** These templates allow the Sky compiler to deal correctly with conversions
** of large unsigneds to float/double.
*/
SCONV,	INAREG|INTAREG,
	EA,	TUNSIGNED,
	SANY,	TFLOAT|TDOUBLE,
		NAREG|NASL,	RESC1,		"/*204*/",
		"Zv",

/*
** I don't want this thing to share L!  The code won't work then.
** As I recall, the problem is that A1 may not hold a double.
** (i.e., the move to U1 may wipe out something).
** OK, I'll try sharing L, see what happens.
*/
SCONV,	INAREG|INTAREG,
	EA,	TINT|TUNSIGNED,
	SANY,	TDOUBLE,
		NAREG|NASL,	RESC1,		"/*205*/",
		"\tmovw\t#0x1044,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n",


SCONV,	INAREG|INTAREG,
	EA,	TINT|TUNSIGNED,
	SANY,	TFLOAT,
		NAREG|NASL,	RESC1,		"/*206*/",
		"\tmovw\t#0x1024,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n",

SCONV,	INAREG|INTAREG,
	EA,	TDOUBLE,
	SANY,	TINT|TUNSIGNED,
		NAREG|NASL,	RESC1,		"/*207*/",
		"\tmovw\t#0x1045,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tZA@,A1\n",

SCONV,	INAREG|INTAREG,
	EA,	TFLOAT,
	SANY,	TINT|TUNSIGNED,
		NAREG|NASL,	RESC1,		"/*208*/",
		"\tmovw\t#0x1027,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n",

# else SKY	/***********************************************************/

SCONV,	FORARG,
	SANY,	TSCALAR,
	SANY,	TSCALAR,
		NAREG,	RNULL,			"/*208.5*/",
		"ZV",

# ifdef IEEE

SCONV,	FORARG,
	EA,	TFLOAT,
	SANY,	TDOUBLE,
		NAREG|NASL,	RESC1,		"/*209*/",
		"\tmovl\tAL,Z-\n\tjbsr\tsptodp\n",


# else IEEE

SCONV,	INAREG|INTAREG,
	EA,	TDOUBLE,
	SANY,	TFLOAT,
		0,	RLEFT,			"/*210*/",
		"",

SCONV,	INAREG|INTAREG,
	EA,	TFLOAT,
	SANY,	TDOUBLE,
		NAREG|NASL,	RESC1,		"/*211*/",
		"	movl	AL,A1\n	clrl	U1\n",

# endif IEEE
# endif SKY	/***********************************************************/

STASG,	FOREFF,
	SNAME|SOREG,	TANY,
	SCON|SBREG,	TANY,
		0,	RNOP,			"/*212*/",
		"ZS",

STASG,	INTBREG|INBREG,
	SNAME|SOREG,	TANY,
	STBREG,	TANY,
		0,	RRIGHT,			"/*213*/",
		"ZS",

STASG, INBREG|INTBREG,
	SNAME|SOREG,	TANY,
	SCON|SBREG,	TANY,
		NBREG,	RESC1,			"/*214*/",
		"ZS	movl	AR,A1\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RNOP,			"/*215*/",
		"	.long	CL\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TSHORT|TUSHORT,
		0,	RNOP,			"/*216*/",
		"	.word	CL\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TCHAR|TUCHAR,
		0,	RNOP,			"/*217*/",
		"	.byte	CL\n",

	/* Default actions for hard trees ... */

# define DF(x) FORREW,SANY,TANY,SANY,TANY,REWRITE,x,"",""

UNARY MUL, DF( UNARY MUL ),

INCR, DF(INCR),

DECR, DF(INCR),

ASSIGN, DF(ASSIGN),

STASG, DF(STASG),

OPLEAF, DF(NAME),

OPLOG,	FORCC,
	SANY,	TANY,
	SANY,	TANY,
		REWRITE,	BITYPE,		"",
		"",

OPLOG,	DF(NOT),

COMOP, DF(COMOP),

INIT, DF(INIT),

OPUNARY, DF(UNARY MINUS),


ASG OPANY, DF(ASG PLUS),

OPANY, DF(BITYPE),

FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	"",	"help; I'm in trouble\n" };
