/* badtrack.c:  Map bad tracks. */
#define NULL	0

char	xxx[2048] = "Mot boot code will NOT load things smaller than 2 blocks";
main()
{
	char line[512];
	int bad, alt;
	int lu;

	printf("Badtrack: Reformat bad tracks to alternate tracks\n");
	printf("Enter the logical unit:");
	gets(line);
	lu = atoi(line);
	printf("that is %d\n", lu);
	setup(lu);
	for (;;) {
		printf("Enter bad track number: ");
		gets(line);
		bad = atoi(line);
		printf("Enter alternate track number: ");
		gets(line);
		alt = atoi(line);
		printf("formatting track %d to %d...", bad, alt);
		spare(lu, bad, alt);
		printf("Done\n");
	}
}

atoi(s)		/* do my own ascii to int */
	char *s;
{
	register char *cp;
	register int n;

	cp = s;
	while (*cp == ' ')
		cp++;
	n = 0;
	while (*cp && *cp >= '0' && *cp <= '9') {
		n *= 10;
		n += *cp++ - '0';
	}
	return n;
}

char	assign[] = { 0xc2, 0, 0, 0, 0, 0 };
char	unit_ready[] = { 0, 0, 0, 0, 0, 0 };
char	plist[] = { 0, 0, 0, 6, 0x4, 0xc7, 0, 0, 16, 0};
char	aat[] = { 14, 0, 0, 0, 0, 0 };
char	ata[] = { 0, 0, 0, 0 };			/* alt. track address */

setup(lu)
{
	unit_ready[1] |= lu << 5;
	scsi(0, unit_ready, NULL, 0, NULL);
	assign[1] |= lu << 5;
	scsi(0, assign, plist, sizeof plist, NULL);
}

spare(lu, bad, alt)
{
	int n;

	bad *= 17;
	alt *= 17;
	aat[1] = bad >> 16 & 0xff;
	aat[1] |= lu << 5;
	aat[2] = bad >> 8 & 0xff;
	aat[3] = bad & 0xff;
	aat[4] = 1;
	aat[5] = 0;

	ata[0] = alt >> 16 & 0xff;
	ata[1] = alt >> 8 & 0xff;
	ata[2] = alt & 0xff;

	n = scsi(0, aat, ata, sizeof ata, NULL);
	printf(" n is %x\n", n);
}
