/* disc: scsi disc driver */

#include <sys/param.h>
#include <sys/inode.h>
#include <sys/types.h>
#include "saio.h"
#include "scsi.h"

#define	setbn(cmd, bn)	{cmd[1] = (bn >> 16) & 0x1f;\
			 cmd[2] = (bn >> 8) & 0xff; \
			 cmd[3] = bn & 0xff;}


discstrategy(io, func)
register struct iob *io;
{
	register u_char *f, *t;
	register int i;
	struct scsi_wh wh;
	struct scsi_rh rh;

	memset((char *)&rh, 0, sizeof rh);
	memset((char *)&wh, 0, sizeof wh);
	if (func == READ) {
		wh.cmd[0] = 8;	/* read */
		wh.flags = SCSI_RD;
	} else {
		wh.cmd[0] = 10;	/* write */
		wh.flags = SCSI_WR;
	}
	setbn(wh.cmd, io->i_bn);
	wh.cmd[4] = (io->i_cc + 511) >> 9;
	wh.target = io->i_unit;
	scsi(&wh, &rh, (char *)io->i_ma, io->i_cc, NULL);
	return io->i_cc;
}

memset(s, c, n)
	register char *s;
	register char c;
	register n;
{
	while (n--)
		*s++ = c;
}
