/* scsi.h:  SCSI drive interface. */

struct	scsi_wh	{		/* scsi write header */
	unsigned long	tran_is;	/* transaction id */
	unsigned char	target;		/* scsi id of target device */
	unsigned char	flags;		/* flags for this transaction */
	char		cmd[10];	/* SCSI command */
};


struct	scsi_rh	{			/* scsi read header */
	unsigned long	tran_id;	/* transaction id */
	unsigned char	status;		/* scsi status byte */
	unsigned char	message;	/* scsi message byte */
	unsigned char	flags;		/* flags for this transaction */
	unsigned char	sense[22];	/* extended sense data */
};

#define	SCSI_WR		001
#define	SCSI_RD		000
#define	SCSI_RESET	002
#define	SCSI_BRESET	004
#define	SCSI_SENSE	010
