/*
 * Declaration of block device switch. Each entry (row) is
 * the only link between the main unix code and the driver.
 * The initialization of the device switches is in the file conf/c.c.
 */
struct bdevsw {
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	struct	buf *d_tab;
};
extern struct bdevsw bdevsw[];

/*
 * Character device switch.
 */
struct cdevsw {
	int		(*d_open)();
	int		(*d_close)();
	int		(*d_read)();
	int		(*d_write)();
	int		(*d_ioctl)();
	int		(*d_stop)();
	struct	tty	*d_ttys;
	struct	qinit	*d_qinit;
};
extern struct cdevsw cdevsw[];

extern int	bdevcnt;
extern int	cdevcnt;

/*
 * To allow mounting of various file system types the following
 * structure is also configured in conf/c.c.
 */

struct fstypsw {
	int		(*t_put)();
	struct inode	*(*t_get)();
	int		(*t_free)();
	int		(*t_updat)();
	int		(*t_read)();
	int		(*t_write)();
	int		(*t_trunc)();
	int		(*t_stat)();
	int		(*t_nami)();
	int		(*t_mount)();
	int		(*t_ioctl)();
	struct inode *	(*t_open)();
	int		(*t_dirread)();
};

/*
extern	int	fstypcnt;
extern	struct	fstypsw	fstypsw[];
*/
