/*
 * Safer versio of system for interactive programs
 */
#include <signal.h>
#include <stdio.h>

system(s)		/* run command lije s*/
	char *s;
{
	int status, pid, w, tty;
	int (*istat)(), (*qstat)();
	extern char *progname;

	fflush(stdout);
	tty = open("/dev/tty", 2);
	if (tty == -1) {
		fprintf(stderr, "%s: can't open /dev/tty\n", progname);
		return -1;
	}
	if ((pid = fork()) == 0) {
		close(0); dup(tty);
		close(1); dup(tty);
		close(2); dup(tty);
		close(tty);
		execlp("sh", "sh", "-c", s, (char *) 0);
		exit(127);
	}
	close(tty);
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	return status;
}


char *sttyin()		/* process responce from /dev/tty */
{
	static char buf[BUFSIZ];
	FILE *efopen();
	static FILE *tty = NULL;

	if (tty == NULL)
		tty = efopen("/dev/tty", "r");
	for (;;) {
		if (fgets(buf, BUFSIZ, tty) == NULL || buf[0] == 'q')
			exit(0);
		else if (buf[0] == '!') {
			system(buf+1);
			printf("!\n");
		}
		else
			return buf;
	}
}

ttyin()		/* process responce from /dev/tty */
{
	static char buf[BUFSIZ];
	FILE *efopen();
	static FILE *tty = NULL;

	if (tty == NULL)
		tty = efopen("/dev/tty", "r");
	for (;;) {
		if (fgets(buf, BUFSIZ, tty) == NULL || buf[0] == 'q')
			exit(0);
		else if (buf[0] == '!') {
			system(buf+1);
			printf("!\n");
		}
		else
			return buf[0];
	}
}
