/*
 *
 *	UNIX debugger
 *
 */
# include <sys/reg.h>
#include "defs.h"

MSG		LONGFIL;
MSG		NOTOPEN;
MSG		A68BAD;
MSG		A68LNK;
MSG		BADMOD;

MAP		txtmap;
MAP		datmap;

ADDR		lastframe;
ADDR		callpc;

INT		infile;
INT		outfile;
CHAR		*lp;
L_INT		maxoff;
L_INT		maxpos;
INT		radix;

/* symbol management */
L_INT		localval;

/* breakpoints */
BKPTR		bkpthead;

#define	D0	0
#define	D1	1
#define	D2	2
#define	D3	3
#define	D4	4
#define	D5	5
#define	D6	6	
#define	D7	7
#define	A0	8
#define	A1	9
#define	A2	10
#define	A3	11
#define	A4	12
#define	A5	13
#define	A6	14
#define	A7	15

struct	pcb {		/* fake Process control block */
	int	pcb_d0;
	int	pcb_d1;
	int	pcb_d2;
	int	pcb_d3;
	int	pcb_d4;
	int	pcb_d5;
	int	pcb_d6;
	int	pcb_d7;
	int	pcb_a0;
	int	pcb_a1;
	int	pcb_a2;
	int	pcb_a3;
	int	pcb_a4;
	int	pcb_a5;
	int	pcb_a6;
	int	pcb_a7;
	int	pcb_psl;
	int	pcb_pc;
	int	pcb_fp;
} pcb;
REGLIST reglist [] = { 
				/* are pcb's really necessary? */
	"d0",	D0,	&pcb.pcb_d2, 0,
	"a0",	A0,	&pcb.pcb_a2, 0,
	"d1",	D1,	&pcb.pcb_d2, 0,
	"a1",	A1,	&pcb.pcb_a2, 0,
	"d2",	D2,	&pcb.pcb_d2, 0,
	"a2",	A2,	&pcb.pcb_a2, 0,
	"d3",	D3,	&pcb.pcb_d3, 0,
	"a3",	A3,	&pcb.pcb_a3, 0,
	"d4",	D4,	&pcb.pcb_d4, 0,
	"a4",	A4,	&pcb.pcb_a4, 0,
	"d5",	D5,	&pcb.pcb_d5, 0,
	"a5",	A5,	&pcb.pcb_a5, 0,
	"d6",	D6,	&pcb.pcb_d6, 0,
	"a6",	A6,	&pcb.pcb_a6, 0,
	"d7",	D7,	&pcb.pcb_d7, 0,
	"sp",	A7,	&pcb.pcb_a7, 0,
	"psl",	PSL,	&pcb.pcb_psl, 0,
	"pc",	PC,	&pcb.pcb_pc, 0
};

char		lastc;

INT		fcor;
STRING		errflg;
INT		signo;
INT		sigcode;


L_INT		dot;
L_INT		var[];
STRING		symfil;
STRING		corfil;
INT		pid;
L_INT		adrval;
INT		adrflg;
L_INT		cntval;
INT		cntflg;

STRING		signals[] = {
		"",
		"hangup",
		"interrupt",
		"quit",
		"illegal instruction",
		"trace/BPT",
		"IOT",
		"EMT",
		"floating exception",
		"killed",
		"bus error",
		"memory fault",
		"bad system call",
		"broken pipe",
		"alarm call",
		"terminated",
		"signal 16",
		"stop (signal)",
		"stop (tty)",
		"continue (signal)",
		"child termination",
		"stop (tty input)",
		"stop (tty output)",
		"input available (signal)",
		"cpu timelimit",
		"file sizelimit",
		"signal 26",
		"signal 27",
		"signal 28",
		"signal 29",
		"signal 30",
		"signal 31",
};

/* general printing routines ($) */

/* floating point support data */

STRING	regname8[] = { "fp0", "fp1", "fp2", "fp3", "fp4", "fp5", "fp6", "fp7",
"fpcr","fpsr","fpiar"};

unsigned short fp_array[NUM_FP_BYTES/2]; /* storage array for 68881 data */
		     /* format: 8 consecutive 96 bit  floating point regs. */
		     /*       + 3 consecutive 32 bit status  registers.     */



printtrace(modif)
{
	INT		narg, i, stat, name, limit;
	POS		dynam;
	REG BKPTR	bkptr;
	CHAR		hi, lo;
	ADDR		word;
	STRING		comptr;
	ADDR		argp, frame, retaddr;
	register struct nlist *sp;
	INT		stack;
	INT		ntramp;
	INT		off;

	IF cntflg==0 THEN cntval = -1; FI

	switch (modif) {

	    case '<':
		IF cntval == 0
		THEN	WHILE readchar() != EOR
			DO OD
			lp--;
			break;
		FI
		IF rdc() == '<'
		THEN	stack = 1;
		ELSE	stack = 0; lp--;
		FI
							/* fall through */
	    case '>':
		{CHAR		file[64];
		CHAR		Ifile[128];
		extern CHAR	*Ipath;
		INT		index;

		index=0;
		IF rdc()!=EOR
		THEN	REP file[index++]=lastc;
			    IF index>=63 THEN error(LONGFIL); FI
			PER readchar()!=EOR DONE
			file[index]=0;
			IF modif=='<'
			THEN	IF Ipath THEN
					strcpy(Ifile, Ipath);
					strcat(Ifile, "/");
					strcat(Ifile, file);
				FI
				IF strcmp(file, "-")!=0
				THEN	iclose(stack, 0);
					infile=open(file,0);
					IF infile<0
					THEN	infile=open(Ifile,0);
					FI
				ELSE	lseek(infile, 0L, 0);
				FI
				IF infile<0
				THEN	infile=0; error(NOTOPEN);
				ELSE	IF cntflg
					THEN	var[9] = cntval;
					ELSE	var[9] = 1;
					FI
				FI
			ELSE	oclose();
				outfile=open(file,1);
				IF outfile<0
				THEN	outfile=creat(file,0644);
#ifndef EDDT
				ELSE	lseek(outfile,0L,2);
#endif
				FI
			FI

		ELSE	IF modif == '<'
			THEN	iclose(-1, 0);
			ELSE	oclose();
			FI
		FI
		lp--;
		}
		break;

#ifdef notdef
	    case 'p':
		IF kernel == 0 THEN
			printf("not debugging kernel\n");
		ELSE
			IF adrflg THEN
				int pte = access(RD, dot, DSP, 0);
				masterpcbb = (pte&PG_PFNUM)*512;
			FI
			getpcb();
		FI
#endif
		break;

	    case 'd':
		if (adrflg) {
			if (adrval<2 || adrval>16) {printf("must have 2 <= radix <= 16"); break;}
			printf("radix=%d base ten",radix=adrval);
		}
		break;

	    case 'q': case 'Q': case '%':
		done();

	    case 'w': case 'W':
		maxpos=(adrflg?adrval:MAXPOS);
		break;

	    case 's': case 'S':
		maxoff=(adrflg?adrval:MAXOFF);
		break;

	    case 'v': case 'V':
		prints("variables\n");
		FOR i=0;i<=35;i++
		DO IF var[i]
		   THEN printc((i<=9 ? '0' : 'a'-10) + i);
			printf(" = %X\n",var[i]);
		   FI
		OD
		break;

	    case 'm': case 'M':
		printmap("? map",&txtmap);
		printmap("/ map",&datmap);
		break;

	    case 0: case '?':
		IF pid
		THEN printf("pcs id = %d\n",pid);
		ELSE prints("no process\n");
		FI
		sigprint(); flushbuf();

	    case 'r': case 'R':
		printregs();
		return;

	    case 'f': case 'F':
		print_fps();
		return;

	    case 'c': case 'C':
		IF adrflg
		THEN frame=adrval;
		ELIF kcore THEN
			frame = pcb.pcb_fp;
			callpc = pcb.pcb_pc;
		ELSE	
			frame= *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[FP]);
			callpc= *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[PC]);
		FI
		lastframe=0;
		ntramp = 0;
		WHILE cntval--
		DO	char *name;
			chkerr();
 			retaddr = get(frame+4,DSP);
	 		argp = frame+8;

			IF retaddr > 0x08200000
			THEN 	name = "sigtramp"; ntramp++;
			ELSE
				ntramp = 0;
				off = findsym(callpc,ISYM);
				IF !cursym THEN
					IF callpc < MINPCVAL
					THEN	break;
					FI
				ELIF !strcmp(cursym->n_un.n_name, "eprol")
				ORF   !strcmp(cursym->n_un.n_name, "Start")
				THEN
					printf("bye2\n");
					break;
				ELIF frame > 0x08200000
				THEN	break;
				FI
				IF cursym
				THEN	name = cursym->n_un.n_name;
				ELSE	name = "?";
				FI
			FI
			printf("%s(", name);
			narg = get(argp,DSP);
			IF narg&~0xFF THEN narg=0; FI
 /*#define ADDQL	0x5080		 addql #x,sp	*/
 /*#define LEA	(short)0x4FEF		 lea sp@(#X),sp	*/
			IF ntramp
			THEN	narg = 3;
			ELSE
 				short inst;
 
 				inst = (unsigned)get(retaddr, ISP) >> 16;
				IF (inst & 0xF1C0) == (short)0x5080
				THEN
 					narg = (inst>>9) & 07;
					IF narg == 0 THEN narg = 8; FI
				ELIF inst == (short)0x4fef
				THEN narg = get(retaddr + 2, ISP) >> 16;
				ELSE narg = 0;
				FI
				IF narg && (narg % 4)
				THEN	narg = (narg / 4) + 1;
				ELSE	narg /= 4;
				FI
			FI
			LOOP IF narg==0 THEN break; FI
 				printf("%R", get(argp, DSP));
 				argp += 4;
				IF --narg!=0 THEN printc(','); FI
			POOL
			IF ntramp == 1
			THEN	callpc=get(frame+54, DSP);
 			ELSE	callpc=retaddr;
			FI
			printf(") + %R\n", off);
			IF modif=='C'
			THEN
			    local_get(name);
			    WHILE localsym(frame, argp)
			     DO word=get(localval,DSP);
				printf("%10t%s:%10t", cursym->n_un.n_name);
				IF errflg THEN prints("?\n"); errflg=0; ELSE printf("%R\n",word); FI
			     OD
			FI

 			argp=frame+8;
			lastframe=frame;
			frame=get(frame, DSP)&EVEN;
			IF frame==0 ORF (!adrflg ANDF !INSTACK(frame))
			THEN break;
			FI
		OD
		break;

	    /*print externals*/
	    case 'e': case 'E':
		for (sp = symtab; sp < esymtab; sp++) {
		   if (sp->n_type==(N_DATA|N_EXT) ORF sp->n_type==(N_BSS|N_EXT))
		   	printf("%s:%12t%R\n", sp->n_un.n_name, get(sp->n_value,DSP));
		}
		break;

	    case 'a': case 'A':
		error("No algol 68 on scunix");
		/*NOTREACHED*/

	    /*print breakpoints*/
	    case 'b': case 'B':
		printf("breakpoints\ncount%8tbkpt%24tcommand\n");
		for (bkptr=bkpthead; bkptr; bkptr=bkptr->nxtbkpt)
			if (bkptr->flag) {
		   		printf("%-8.8d",bkptr->count);
				psymoff(bkptr->loc,ISYM,"%24t");
				comptr=bkptr->comm;
				WHILE *comptr DO printc(*comptr++); OD
			}
		break;

	    default: error(BADMOD);
	}

}

printmap(s,amap)
STRING	s; MAP *amap;
{
	int file;
	file=amap->ufd;
	printf("%s%12t`%s'\n",s,(file<0 ? "-" : (file==fcor ? corfil : symfil)));
	printf("b1 = %-16R",amap->b1);
	printf("e1 = %-16R",amap->e1);
	printf("f1 = %-16R",amap->f1);
	printf("\nb2 = %-16R",amap->b2);
	printf("e2 = %-16R",amap->e2);
	printf("f2 = %-16R",amap->f2);
	printc(EOR);
}

printregs()
{
	REG REGPTR	p;
	L_INT		v;

	FOR p=reglist; p < &reglist[RGLSTSZ]; p+=2
	DO	v = *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[p->roffs]);
		printf("%s%6t%R %32t", p->rname, v);
		v = *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[(p+1)->roffs]);
		printf("%s%6t%R %16t", (p+1)->rname, v);
		valpr(v,((p+1)->roffs==PC?ISYM:DSYM));
		printc(EOR);
	OD
	printpc();
}

/* print out contents of floating point registers */
print_fps()
{
struct regname8 *p;
short *vp;
int i,j;

long test = 0xfedcba987654321;

	printf("\n");

	/*vp =  &u.u_68881_regs[0];*/


	for (i = 0;i<NUM_FPS;)
 		{
		printf("%s%6t ",(char *)regname8[i]);
		put_fp_reg(i);

		i++;
		printf("\n");
		}
	for (i = NUM_FPS; i <(NUM_FPS + NUM_FP_STAT);i++)
	   {
	   printf("%s%6t ",(char *)regname8[i]);
	   put_fp_st(i);
	   printf("     ");
	   }
	printf("\n");
}

/* put_fp_reg  print the contents of a floating point register 
*/
put_fp_reg(reg_num)
{
	unsigned short *sp;
	int i,j;
	unsigned char f_list[40];

	sp = &fp_array[reg_num * (FP_SIZE/2)];	

	for (i =0; i < (FP_SIZE/2);i++)
	   {
		   sprintf(f_list,"%04x",*sp++);
		   printf("%s",f_list);

	   }	
}

put_fp_st(reg_num)
{
	unsigned short *sp;
	int i,j;
	unsigned char f_list[40];

	sp = &fp_array[reg_num * (FP_SIZE/2)];	

	for (i =0; i < (STAT_SIZE/2);i++)
	   {
		   sprintf(f_list,"%04x",*sp++);
		   printf("%s",f_list);

	   }	
}
int
findreg(regoff)
int regoff;
{
	REG int	i;

	for (i=0; i < RGLSTSZ; i++)
	{
		if (reglist[i].roffs == regoff)
			return i;
	}
	return 0;
}

getreg(regnam) {
	REG REGPTR	p;
	REG STRING	regptr;
	CHAR	*olp;
	CHAR		regnxt;

	olp=lp;
	FOR p=reglist; p < &reglist[RGLSTSZ]; p++
	DO	regptr=p->rname;
		IF (regnam == *regptr++)
		THEN
			WHILE *regptr
			DO IF (regnxt=readchar()) != *regptr++
				THEN --regptr; break;
				FI
			OD
			IF *regptr
			THEN lp=olp;
			ELSE
				int i = kcore ? (int)p->rkern : p->roffs;
				return (i);
			FI
		FI
	OD
	lp=olp;
	return(0);
}

printpc()
{
	int w;

	dot= *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[PC]);
	w = (chkget(dot, ISP) >> 16) & 0xffff;
	psymoff(dot, ISYM, ":%16t");
	printins(ISP, w);
	printc(EOR);
}

char	*illinames[] = {
	"reserved addressing fault",
	"priviliged instruction fault",
	"reserved operand fault"
};
char	*fpenames[] = {
	0,
	"integer overflow trap",
	"integer divide by zero trap",
	"floating overflow trap",
	"floating/decimal divide by zero trap",
	"floating underflow trap",
	"decimal overflow trap",
	"subscript out of range trap",
	"floating overflow fault",
	"floating divide by zero fault",
	"floating undeflow fault"
};

sigprint()
{
	IF (signo>=0) ANDF (signo<sizeof signals/sizeof signals[0])
	THEN prints(signals[signo]); FI
	switch (signo) {

	case SIGFPE:
		IF (sigcode > 0 &&
		    sigcode < sizeof fpenames / sizeof fpenames[0]) THEN
			prints(" ("); prints(fpenames[sigcode]); prints(")");
		FI
		break;

	case SIGILL:
		IF (sigcode >= 0 &&
		    sigcode < sizeof illinames / sizeof illinames[0]) THEN
			prints(" ("); prints(illinames[sigcode]); prints(")");
		FI
		break;
	}
}
