
# line 2 "commands.y"
static char *RCSid = "$Header$";

/*
 * $Log$
 */


/* Copyright (c) 1982 Regents of the University of California */


/*
 * Yacc grammar for debugger commands.
 */

#include "defs.h"
#include "symbols.h"
#include "operators.h"
#include "tree.h"
#include "process.h"
#include "source.h"
#include "scanner.h"
#include "names.h"
#include "lists.h"

private String curformat = "X";


# line 49 "commands.y"
typedef union  {
    Name y_name;
    Symbol y_sym;
    Node y_node;
    Integer y_int;
    Operator y_op;
    long y_long;
    double y_real;
    String y_string;
    Boolean y_bool;
    Cmdlist y_cmdlist;
    List y_list;
} YYSTYPE;
# define ALIAS 257
# define AND 258
# define ASSIGN 259
# define AT 260
# define CALL 261
# define CATCH 262
# define CONT 263
# define DEBUG 264
# define DELETE 265
# define DIV 266
# define DOWN 267
# define DUMP 268
# define EDIT 269
# define FILE 270
# define FUNC 271
# define GRIPE 272
# define HELP 273
# define IF 274
# define IGNORE 275
# define IN 276
# define LIST 277
# define MOD 278
# define NEXT 279
# define NEXTI 280
# define NIL 281
# define NOT 282
# define OR 283
# define PRINT 284
# define PSYM 285
# define QUIT 286
# define RERUN 287
# define RETURN 288
# define RUN 289
# define SH 290
# define SKIP 291
# define SOURCE 292
# define STATUS 293
# define STEP 294
# define STEPI 295
# define STOP 296
# define STOPI 297
# define TRACE 298
# define TRACEI 299
# define UP 300
# define USE 301
# define WHATIS 302
# define WHEN 303
# define WHERE 304
# define WHEREIS 305
# define WHICH 306
# define INT 307
# define REAL 308
# define NAME 309
# define STRING 310
# define LFORMER 311
# define RFORMER 312
# define ABSTRACTION 313
# define ARROW 314
# define REDIRECT 315
# define UNARYSIGN 316
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 140,
	276, 0,
	-2, 187,
-1, 284,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 140,
-1, 287,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 142,
-1, 289,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 144,
-1, 310,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 141,
-1, 311,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 146,
-1, 312,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 143,
-1, 313,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 145,
-1, 314,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 147,
-1, 318,
	62, 78,
	10, 78,
	59, 78,
	-2, 158,
	};
# define YYNPROD 218
# define YYLAST 2136
short yyact[]={

  70, 183, 182, 148, 182, 149, 295,  69, 146, 264,
 147,  72, 254, 253, 211, 183, 127, 168, 156, 202,
 133, 128, 125, 124, 155, 199, 285, 286, 243,  56,
 175, 181, 217, 209, 137, 126, 247, 210, 305, 222,
 197, 291, 155, 129, 242,  66,  63, 190, 188, 186,
 189, 320, 185, 317,  70, 274, 235, 148, 130, 149,
 213,  69, 146, 153, 147,  72, 187, 160, 180, 136,
 198, 251, 190, 201, 157, 318, 173, 138, 306, 174,
 290, 190, 188, 299, 189,   6, 304, 298,  45,   5,
  23, 194,   3,   2,   1,  64, 246, 296,  35,  19,
   7, 191, 192, 145, 159,  38, 152,  26,  70,  74,
 196, 148,  65, 149,  27,  69, 146,  28, 147,  72,
   0,   0,   0,   0, 184,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 288,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 297,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  70, 208, 212, 148,   0, 149,   0,  69,
 146,   0, 147,  72, 214,  60, 173,  62,   0,  61,
   0,   0,   0,   0,   0,   0,   0, 240, 245,   0,
 178,   0, 179,   0,   0,   0,   0,   0,   0,   0,
   0, 269,   0,   0,   0, 252,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 258, 257, 260, 261,
 262,   0,  75,  76,  77,  78,  79,  80,  81,  82,
  83,  84,  85,  86,  87,  88,  89,  90,  91,   0,
  92,  93,  94,  95,  96,  97,  98,  99, 100, 101,
 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
 122, 123, 150, 151,  73, 162,  75,  76,  77,  78,
  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,
  89,  90,  91, 200,  92,  93,  94,  95,  96,  97,
  98,  99, 100, 101, 102, 103, 104, 105, 106, 107,
 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
 118, 119, 120, 121, 122, 123, 150, 151,  73, 162,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,
  85,  86,  87,  88,  89,  90,  91, 172,  92,  93,
  94,  95,  96,  97,  98,  99, 100, 101, 102, 103,
 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
 150, 151,  73, 162,  75,  76,  77, 141,  79,  80,
  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,
  91, 155,  92, 140,  94,  95,  96,  97,  98,  99,
 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
 120, 121, 122, 123, 150, 151,  73, 143,  70, 176,
 177, 148, 316, 149,  59,  69, 146, 172, 147,  72,
 221, 301,   0,   0,   0,   0,   0, 202,   0,   0,
   0,   0,   0, 199,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  70,   0,   0, 148,   0, 149,   0,  69,
 146,   0, 147,  72,   0,   0,   0,   0, 198,   0,
   0, 201,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  70,   0,   0, 148,
   0, 149,   0,  69, 146,   0, 147,  72,   0,   0,
   0,   0,   0,   0,   0, 249,   0,   0,   0,   0,
   0, 199,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  70,   0,   0,   0,   0, 206,   0,  69,   0,   0,
   0,  72,   0,   0,   0,   0, 198,   0,   0, 201,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  75,  76,  77, 141,  79,  80,  81,  82,  83,  84,
  85,  86,  87,  88,  89,  90,  91, 139,  92, 140,
  94,  95,  96,  97,  98,  99, 100, 101, 102, 103,
 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
 150, 151,  73, 143,  75,  76,  77,  78,  79,  80,
  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,
  91, 200,  92,  93,  94,  95,  96,  97,  98,  99,
 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
 120, 121, 122, 123, 150, 151,  73, 162,  75,  76,
  77, 141,  79,  80,  81,  82,  83,  84,  85,  86,
  87,  88,  89,  90,  91, 255,  92, 140,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 104, 105,
 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
 116, 117, 118, 119, 120, 121, 122, 123, 150, 151,
  73, 162,  75,  76,  77,  78,  79,  80,  81,  82,
  83,  84,  85,  86,  87,  88,  89,  90,  91, 200,
  92,  93,  94,  95,  96,  97,  98,  99, 100, 101,
 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
 122, 123,  70,   0,  73,   0,   0, 204,   0,  69,
   0,   0,   0,  72,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 144,  68,   0,   0,  70,   0,   0,   0,   0,
  67,   0,  69,   0,   0,   0,  72,   0, 132,   0,
   0,   0, 134,   0,   0, 132,   0,   0,   0,   0,
   0,   0,   0, 158,   0,   0, 163, 164,   0,   0,
   0, 167,   0,   0,   0,   0,   0, 132,   0,   0,
   0,   0,   0, 259, 131,   0,   0,   0,   0, 173,
   0,   0, 193,   0,   0,   0,   0,   0,   0,  72,
   0, 203, 205,   0,   0,   0,   0, 135,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 171,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  70,   0,   0,   0,   0,   0,   0,  69,   0,
   0,   0,  72, 303,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 219,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 319,   0,   0,   0,  75,  76,  77,  78,  79,  80,
  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,
  91,  72,  92,  93,  94,  95,  96,  97,  98,  99,
 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
 120, 121, 122, 123,   0, 132,  73,  75,  76,  77,
  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,
  88,  89,  90,  91, 219,  92,  93,  94,  95,  96,
  97,  98,  99, 100, 101, 102, 103, 104, 105, 106,
 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
 117, 118, 119, 120, 121, 122, 123, 275,   0,  73,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,
  85,  86,  87,  88,  89,  90,  91,   0,  92,  93,
  94,  95,  96,  97,  98,  99, 100, 101, 102, 103,
 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
 172,   0,  73,  75,  76,  77,  78,  79,  80,  81,
  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,
 220,  92, 270,  94,  95,  96,  97,  98,  99, 100,
 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
 111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
 121, 122, 123, 154,   0,  73,   0,   0,   0, 165,
   0,   0,   0,   0,   0, 170,   0,   0,   0,   0,
   0,   0,  75,  76,  77,  78,  79,  80,  81,  82,
  83,  84,  85,  86,  87,  88,  89,  90,  91,   0,
  92,  93,  94,  95,  96,  97,  98,  99, 100, 101,
 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
 122, 123,   0,   0,  73,  75,  76,  77,  78,  79,
  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,   0,  92,  93,  94,  95,  96,  97,  98,
  99, 100, 101, 102, 103, 104, 105, 106, 107, 108,
 109, 110, 111, 112, 113, 114, 115, 116, 117, 118,
 119, 120, 121, 122, 123,   0,  60,  73,  62,   0,
  61,   0,   0,   0,   0,  54,   0,   0,   0,   0,
   0, 215, 216,   0,   0,   0,   0,   0,   0,   4,
   0,  55,   0,   0,   0,   0, 241, 244,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 266,   0,   0,   0,   0,   0,  60,   0,  62,
   0,  61,   0,   0,   0,   0,  54,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  55,   0,   0,   0, 292,   0,   0,   0,
   0,   0,   0, 315,   0,   0,   0,   0,   0,   0,
   0, 300, 302,   0,   0,   0,   0,   0,  60,   0,
  62,   0,  61,   0,   0,   0,   0,  54,   0,   0,
   0,   0,   0,   0, 294, 309,   0,   0,   0,   0,
   0,   0,   0,  55,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,
 234, 308, 225, 223,   0, 224,   0, 226, 307, 225,
 223,   0, 224,   0, 226,   0,   0,   0,   0,   0,
 231, 233, 232,   0,   0,   0,   0, 231, 233, 232,
   0,   0,   0,   0,   0,   0, 225, 223,   0, 224,
 225, 226,   0,   0,   0, 226,   0,   0,   0,   0,
   0,   0, 222,   0,   0,   0,   0,   0,   0, 222,
   0,   0,   0,   0,   0,  43,   0,   8,   0,  39,
   9,  10,  40,  11,   0,  12,  41,  13,  14,  15,
  16,  17,   0,  18,   0,  44, 222,  48,  49,   0,
 222,   0,  36,  20,  21,  58,  22,  57,  24,   0,
  25,  42,  46,  47,  50,  51,  52,  53,  29,  30,
  31,  32,  37,  33,  34,  59,  43,   0,   8,   0,
  39,   9,  10,  40,  11,   0,  12,  41,  13,  14,
  15,  16,  17,   0,  18,   0,  44,   0,  48,  49,
   0,   0,   0,  36,  20,  21,  58,  22,  57,  24,
   0,  25,  42,  46,  47,  50,  51,  52,  53,  29,
  30,  31,  32,  37,  33,  34,  59,  43,   0,   8,
   0,  39,   9,  10,  40,  11,   0,  12,  41,  13,
  14,  15,  16,  17,   0,  18,  71,  44,   0,  48,
  49, 166,   0,   0,  36,  20,  21,  58,  22,  57,
  24,   0,  25,  42,  46,  47,  50,  51,  52,  53,
  29,  30,  31,  32,  37,  33,  34,  59, 229, 142,
 142,   0,   0,   0, 161, 229, 227,   0,   0,   0,
 169,   0,   0, 227,   0,   0,   0,   0, 228, 234,
   0,   0,   0, 230,   0, 228,   0, 293, 225, 223,
 230, 224, 229, 226, 195,   0, 229,   0,   0, 207,
 227, 234,   0,   0, 227,   0, 231, 233, 232, 263,
 225, 223, 228, 224,   0, 226, 228, 230,   0,   0,
   0,   0,   0, 234,   0,   0,   0,   0, 231, 233,
 232,   0, 225, 223, 248, 224,   0, 226, 222,   0,
   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,
 231, 233, 232,   0, 225, 223,   0, 224,   0, 226,
 222,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 218, 231, 233, 232,   0,   0,   0, 236, 237,
 238, 239, 222,   0,   0,   0,   0, 218,   0,   0,
   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,
   0,   0,   0,   0, 222,   0,   0,   0, 256,   0,
   0,   0,   0,   0, 256,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 267, 268,   0, 265,
   0,   0,   0,   0,   0,   0, 271,   0, 272,   0,
 273,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 276, 277, 278, 279, 280,
 281, 282, 283, 284, 287, 289,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 256,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 229,   0,   0,   0,   0,   0,
   0,   0, 227,   0,   0,   0,   0, 310, 311,   0,
 312,   0, 313, 314, 228,   0, 229,   0,   0, 230,
   0, 256,   0,   0, 227,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 228,   0, 229,   0,
   0, 230,   0,   0,   0,   0, 227,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 228,   0,
 229,   0,   0, 230,   0,   0,   0,   0, 227,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 228,   0,   0,   0,   0, 230 };
short yypact[]={

-1000,1439,-1000,  36,-1000,-1000, -17,-1000, 890,-284,
-285,-291,-286,-1000,-1000,1065,-1000,-1000,-287,-1000,
 890,-1000,1065,-1000,-1000,-1000,-1000, 403, 127,-289,
-1000, 890, 511,1065,1065,-1000, 457,-1000,-1000, 890,
-290,-1000,-1000,1118, 943, 130,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-306,-308,   5,-1000,-1000,-1000,
 890, 137, 457,-1000,-1000,-1000,-1000, -21,-1000, 837,
 565,-1000,1118,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-291,-1000,-295,
-295,  14,-1000,-1000, 417,  14,-295,-250,-250, 457,
 996, 140,1852,  -2, 417,-1000, 457, 457, 457, 457,
-1000,-1000,-232,-250,-1000, 457,-1000,-1000, 417, -87,
-1000,1852,-1000,-1000,-1000,-1000,1830, 525,-1000,1118,
  27,  14,-1000,-1000, 130,-1000,-1000,-1000,-296,-297,
-1000,1118,-1000,-1000,-1000,-292, 137,1118, 137, 137,
 137,-1000,-1000, 417,  30,1808,-300, 457, 457,1118,
1118,-1000, 457, 417, 457, 417, 457,-1000,-1000,-1000,
-1000,-1000,-1000,1118,-1000,-1000,-1000,-1000,1852, 417,
-1000,  -3,1065, 457, 457, 457, 457, 457, 457, 457,
 457, -35,  73,  19, -20,  40,1578,1578,1578,1786,
-250,-1000, 890, 140,-1000,-1000,-303,1490, 457, 457,
-1000,  40,-1000,-1000,-1000,-1000,-1000,1118,  39,-1000,
  30,  30,-1000,-1000,-1000,1852, -55,-1000,-1000,  37,
-1000,1547,1540,-1000,  40,  14,1578,1578, -53, -53,
 -53, -53, -53,1578,1574, 457, 457,1574, 457,1574,
 457, 457,-1000,-1000,-1000,-1000,1388,  -6,-1000,-1000,
-1000,  34,-1000,-1000,1118,-1000,-1000,-1000,-1000,-1000,
1574,1574,1574,1574,1574,-1000,  -8,-1000,-1000,-1000,
-1000 };
short yypgo[]={

   0, 117, 114,  31, 112,  37,  33, 785,1766, 109,
 974, 922,  87,  83, 145, 107,  77,  34, 105, 104,
 201,1303,1272,1771, 921,  32, 103,  29,  35, 100,
  99,1270,  98,  68,  97,  96,  94,  93,  92,  43,
  90,  88,  79,  30 };
short yyr1[]={

   0,  36,  36,  37,  37,  37,  38,  38,   4,   4,
  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,
  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,
  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,
  12,  12,  12,  12,  12,  12,  12,  12,  12,  32,
  32,  33,  40,  40,  41,  41,  42,  42,  43,  43,
  43,  43,  15,  15,  15,  15,  39,  35,  35,  19,
  19,  34,  34,  14,  14,  13,  13,  13,  13,  13,
  13,  13,  29,  29,  29,   1,   1,   2,   2,  16,
  16,  17,  17,  17,   5,   6,   6,  20,  20,  30,
  30,  30,  30,  28,  28,  31,  31,  18,  18,  18,
  18,  27,  27,  27,  27,  27,  27,  27,   3,   3,
   7,   7,  21,  21,  22,  22,  23,  23,  23,  23,
  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,
  23,  23,  23,  23,  23,  23,  23,  23,  23,  24,
  24,  24,  24,  24,  24,  24,  24,  24,  24,  25,
  26,  26,  26,  10,  10,  11,  11,   8,   8,   9,
   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
   9,   9,   9,   9,   9,   9,   9,   9 };
short yyr2[]={

   0,   2,   0,   2,   2,   1,   1,   2,   3,   0,
   1,   4,   2,   1,   2,   2,   1,   2,   3,   3,
   1,   2,   1,   1,   2,   1,   2,   1,   1,   2,
   1,   1,   3,   1,   3,   3,   3,   4,   3,   3,
   2,   1,   2,   3,   2,   5,   2,   2,   1,   2,
   2,   1,   2,   1,   2,   2,   2,   1,   1,   1,
   2,   2,   1,   1,   1,   1,   0,   2,   0,   1,
   1,   3,   2,   1,   1,   2,   1,   1,   5,   2,
   1,   1,   3,   2,   1,   1,   1,   1,   1,   1,
   3,   2,   2,   4,   1,   0,   1,   1,   0,   1,
   2,   4,   2,   1,   2,   1,   1,   4,   5,   3,
   3,   1,   2,   3,   3,   3,   2,   3,   0,   1,
   1,   0,   0,   2,   1,   3,   1,   1,   3,   2,
   2,   2,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   4,   3,   4,   3,   4,   4,   4,   3,   1,
   4,   3,   3,   2,   4,   2,   2,   4,   4,   1,
   1,   1,   1,   1,   3,   1,   2,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1 };
short yychk[]={

-1000, -36, -37, -38,  10, -12, -13, -29, 259, 262,
 263, 265, 267, 269, 270, 271, 272, 273, 275, -30,
 285, 286, 288, -40, 290, 292, -15,  -2,  -1, 300,
 301, 302, 303, 305, 306, -32, 284, 304, -18, 261,
 264, 268, 293, 257, 277, -41, 294, 295, 279, 280,
 296, 297, 298, 299,  47,  63, -27, 289, 287, 307,
  38,  42,  40,  10,  59,  -4,  62, -24, -11,  42,
  35,  -8,  46, 309,  -9, 257, 258, 259, 260, 261,
 262, 263, 264, 265, 266, 267, 268, 269, 270, 271,
 272, 273, 275, 276, 277, 278, 279, 280, 281, 282,
 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
 293, 294, 295, 296, 297, 298, 299, 300, 301, 302,
 303, 304, 305, 306, 307, 307, -28, 307, 307, -39,
 -39, -10, -11, 307, -24, -10, -39, -17, -16, 274,
 276, 260, -23, 310, -24, -26,  43,  45,  38,  40,
 307, 308, -16, -17, -21, 274, 307, -39, -24, -19,
 -17, -23, 310, -11, -11, -22, -23, -24, 307,  -8,
 -31, -10, 307,  36, -42, -43, 309, 310,  60,  62,
 -33,  -3, 310, 307, -33,  47,  44,  61,  43,  45,
  42, -39, -39, -24, -27, -23, -39,  61,  91,  46,
 314,  94,  40, -24,  40, -24,  40,  -8, -28,  -6,
  -5, 309,  -6,  46,  -5, -21, -21, -25, -23, -24,
 -31, 310,  92,  43,  45,  42,  47, 266, 278, 258,
 283,  60,  62,  61,  33,  58, -23, -23, -23, -23,
 -17, -21, 276, 260, -21, -25, -35, 123,  44,  40,
  -8,  44, -43, 309, 309,  -7,  -8,  -3, -27,  -7,
 -27, -27, -27,  41, 309, -23, -22,  -8,  -8, -20,
 -22, -23, -23,  -8,  58, -10, -23, -23, -23, -23,
 -23, -23, -23, -23, -23,  61,  62, -23,  61, -23,
  61,  61, -31,  41, -21, 309, -34, -14, -12, -13,
 -22, -20, -31,  -7,  47,  93,  41,  41,  41, -31,
 -23, -23, -23, -23, -23, 125, -14,  59,  41,  -7,
  59 };
short yydef[]={

   2,  -2,   1,   0,   5,   6,   9,  10,   0,   0,
  13,   0,  16,  66,  66,  20,  22,  23,   0,  25,
   0,  27,  28,  30,  31,  66,  33,   0, 122,  41,
  66,   0,   0,   0,   0,  48,   0,  76,  77,   0,
   0,  80,  81,  84,  99,  53,  62,  63,  64,  65,
  87,  88,  85,  86, 118,   0,   0,  66,  66, 111,
   0,   0,   0,   3,   4,   7,  66,   0, 149,   0,
   0, 165,   0, 167, 168, 169, 170, 171, 172, 173,
 174, 175, 176, 177, 178, 179, 180, 181, 182, 183,
 184, 185, 186, 187, 188, 189, 190, 191, 192, 193,
 194, 195, 196, 197, 198, 199, 200, 201, 202, 203,
 204, 205, 206, 207, 208, 209, 210, 211, 212, 213,
 214, 215, 216, 217,  12,  14,  15, 103,  17,  95,
  95,  21, 163,  24,  26,  29,   0, 122, 122,   0,
  -2, 172,  89, 162, 126, 127,   0,   0,   0,   0,
 160, 161, 122, 122,  40,   0,  42,  68,  44,   0,
  69,  70, 162,  46,  47,  75, 124,   0,  79,  83,
 100, 102, 105, 106,  52,  57,  58,  59,   0,   0,
  49, 121,  51, 119,  50, 118,   0, 121,   0,   0,
   0,  54,  55, 112, 116,   0,   0,   0,   0,   0,
   0, 155,  98, 153,   0, 156,   0, 166, 104,  18,
  96,  94,  19,   0,  32,  34,  35,  36, 159,  91,
  92,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 129, 130, 131,   0,
 122,  39,   0,   0,  38, 123,  43,   0,   0,  98,
  82,   0,  56,  60,  61, 109, 120, 121,   0, 110,
 113, 114, 115, 117,   8,  11,   0, 151, 152,   0,
  97,   0,   0, 164,   0, 128, 132, 133, 134, 135,
 136, 137, 138, 139,  -2,   0,   0,  -2,   0,  -2,
   0,   0,  90, 148,  37,  67,   0,   0,  73,  74,
 125,   0, 101, 107, 121, 150, 158, 154, 157,  93,
  -2,  -2,  -2,  -2,  -2,  45,   0,  72,  -2, 108,
  71 };
#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

int yydebug = 0; /* 1 for debugging */
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

			if( yydebug ) printf( "error recovery discards char %d\n", yychar );

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

		if( yydebug ) printf("reduce %d\n",yyn);
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 6:
# line 101 "commands.y"
{
	if (yypvt[-0].y_node != nil) {
            if(debug_flag[2]) {dumptree(stderr,yypvt[-0].y_node); fflush (stderr);}
	    eval(yypvt[-0].y_node);
	}
} break;
case 7:
# line 109 "commands.y"
{
	if (yypvt[-1].y_node != nil) {
	    if (yypvt[-0].y_string != nil) {
		setout(yypvt[-0].y_string);
                if(debug_flag[2]) {dumptree(stderr,yypvt[-1].y_node); fflush (stderr);}
		eval(yypvt[-1].y_node);
		unsetout();
	    } else {
                if(debug_flag[2]) {dumptree(stderr,yypvt[-1].y_node); fflush (stderr);}
		eval(yypvt[-1].y_node);
	    }
	}
} break;
case 8:
# line 125 "commands.y"
{
	yyval.y_string = ident(yypvt[-0].y_name);
} break;
case 9:
# line 130 "commands.y"
{
	yyval.y_string = nil;
} break;
case 10:
# line 140 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 11:
# line 145 "commands.y"
{
	yyval.y_node = build(O_ASSIGN, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 12:
# line 150 "commands.y"
{
	yyval.y_node = build(O_CATCH, yypvt[-0].y_long);
} break;
case 13:
# line 155 "commands.y"
{
	yyval.y_node = build(O_CONT, (long) DEFSIG);
} break;
case 14:
# line 160 "commands.y"
{
	yyval.y_node = build(O_CONT, yypvt[-0].y_long);
} break;
case 15:
# line 165 "commands.y"
{
	yyval.y_node = build(O_DELETE, yypvt[-0].y_node);
} break;
case 16:
# line 170 "commands.y"
{
	yyval.y_node = build(O_DOWN, build(O_LCON, (long) 1));
} break;
case 17:
# line 175 "commands.y"
{
	yyval.y_node = build(O_DOWN, build(O_LCON, (long) yypvt[-0].y_long));
} break;
case 18:
# line 180 "commands.y"
{
	yyval.y_node = build(O_EDIT, yypvt[-0].y_string);
} break;
case 19:
# line 185 "commands.y"
{
	yyval.y_node = build(O_CHFILE, yypvt[-0].y_string);
} break;
case 20:
# line 190 "commands.y"
{
	yyval.y_node = build(O_FUNC, nil);
} break;
case 21:
# line 195 "commands.y"
{
	yyval.y_node = build(O_FUNC, yypvt[-0].y_node);
} break;
case 22:
# line 200 "commands.y"
{
	yyval.y_node = build(O_GRIPE);
} break;
case 23:
# line 205 "commands.y"
{
	yyval.y_node = build(O_HELP);
} break;
case 24:
# line 210 "commands.y"
{
	yyval.y_node = build(O_IGNORE, yypvt[-0].y_long);
} break;
case 25:
# line 215 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 26:
# line 220 "commands.y"
{
	yyval.y_node = build(O_PSYM, yypvt[-0].y_node);
} break;
case 27:
# line 225 "commands.y"
{
	if (not popinput()) {
	    quit(0);
	} else {
	    yyval.y_node = nil;
	}
} break;
case 28:
# line 234 "commands.y"
{
	yyval.y_node = build(O_RETURN, nil);
} break;
case 29:
# line 239 "commands.y"
{
	yyval.y_node = build(O_RETURN, yypvt[-0].y_node);
} break;
case 30:
# line 244 "commands.y"
{
	run();
	/* NOTREACHED */
} break;
case 31:
# line 250 "commands.y"
{
	shellline();
	yyval.y_node = nil;
} break;
case 32:
# line 256 "commands.y"
{
	yyval.y_node = build(O_SOURCE, yypvt[-0].y_string);
} break;
case 33:
# line 261 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 34:
# line 266 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, nil, yypvt[-1].y_node, yypvt[-0].y_node);
} break;
case 35:
# line 271 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, yypvt[-1].y_node, nil, yypvt[-0].y_node);
} break;
case 36:
# line 276 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, nil, nil, yypvt[-0].y_node);
} break;
case 37:
# line 281 "commands.y"
{
	yyval.y_node = build(yypvt[-3].y_op, yypvt[-2].y_node, yypvt[-1].y_node, yypvt[-0].y_node);
} break;
case 38:
# line 286 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, nil, yypvt[-1].y_node, yypvt[-0].y_node);
} break;
case 39:
# line 291 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, yypvt[-1].y_node, nil, yypvt[-0].y_node);
} break;
case 40:
# line 296 "commands.y"
{
	yyval.y_node = build(yypvt[-1].y_op, nil, nil, yypvt[-0].y_node);
} break;
case 41:
# line 301 "commands.y"
{
	yyval.y_node = build(O_UP, build(O_LCON, (long) 1));
} break;
case 42:
# line 306 "commands.y"
{
	yyval.y_node = build(O_UP, build(O_LCON, (long) yypvt[-0].y_long));
} break;
case 43:
# line 311 "commands.y"
{
	String dir;

	yyval.y_node = nil;
	if (list_size(yypvt[-0].y_list) == 0) {
	    foreach (String, dir, sourcepath)
		printf("%s ", dir);
	    endfor
	    printf("\n");
	} else {
	    foreach (String, dir, sourcepath)
		list_delete(list_curitem(sourcepath), sourcepath);
	    endfor
	    sourcepath = yypvt[-0].y_list;
	}
} break;
case 44:
# line 329 "commands.y"
{
	yyval.y_node = build(O_WHATIS, yypvt[-0].y_node);
} break;
case 45:
# line 334 "commands.y"
{
	yyval.y_node = build(O_ADDEVENT, yypvt[-3].y_node, yypvt[-1].y_cmdlist);
} break;
case 46:
# line 339 "commands.y"
{
	yyval.y_node = build(O_WHEREIS, yypvt[-0].y_node);
} break;
case 47:
# line 344 "commands.y"
{
	yyval.y_node = build(O_WHICH, yypvt[-0].y_node);
} break;
case 48:
# line 349 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 49:
# line 357 "commands.y"
{
	yyval.y_node = build(O_SEARCH, build(O_LCON, 1), yypvt[-0].y_node);
} break;
case 50:
# line 362 "commands.y"
{
	yyval.y_node = build(O_SEARCH, build(O_LCON, 0), yypvt[-0].y_node);
} break;
case 51:
# line 369 "commands.y"
{
	yyval.y_node = build(O_SCON, yypvt[-0].y_string);
} break;
case 54:
# line 381 "commands.y"
{
	arginit();
	fflush(stdout);
} break;
case 55:
# line 387 "commands.y"
{
	fflush(stdout);
} break;
case 58:
# line 398 "commands.y"
{
	newarg(ident(yypvt[-0].y_name));
} break;
case 59:
# line 403 "commands.y"
{
	newarg(yypvt[-0].y_string);
} break;
case 60:
# line 408 "commands.y"
{
	inarg(ident(yypvt[-0].y_name));
} break;
case 61:
# line 413 "commands.y"
{
	outarg(ident(yypvt[-0].y_name));
} break;
case 62:
# line 419 "commands.y"
{
	yyval.y_node = build(O_STEP, true, false);
} break;
case 63:
# line 424 "commands.y"
{
	yyval.y_node = build(O_STEP, false, false);
} break;
case 64:
# line 429 "commands.y"
{
	yyval.y_node = build(O_STEP, true, true);
} break;
case 65:
# line 434 "commands.y"
{
	yyval.y_node = build(O_STEP, false, true);
} break;
case 66:
# line 440 "commands.y"
{
	beginshellmode();
} break;
case 67:
# line 446 "commands.y"
{
	yyval.y_list = yypvt[-1].y_list;
	list_append(list_item(ident(yypvt[-0].y_name)), nil, yyval.y_list);
} break;
case 68:
# line 452 "commands.y"
{
	yyval.y_list = list_alloc();
} break;
case 71:
# line 463 "commands.y"
{
	yyval.y_cmdlist = yypvt[-2].y_cmdlist;
	cmdlist_append(yypvt[-1].y_node, yyval.y_cmdlist);
} break;
case 72:
# line 469 "commands.y"
{
	yyval.y_cmdlist = list_alloc();
	cmdlist_append(yypvt[-1].y_node, yyval.y_cmdlist);
} break;
case 75:
# line 485 "commands.y"
{
	yyval.y_node = build(O_PRINT, yypvt[-0].y_node);
} break;
case 76:
# line 490 "commands.y"
{
	yyval.y_node = build(O_WHERE);
} break;
case 77:
# line 495 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 78:
# line 500 "commands.y"
{
	yyval.y_node = build(O_CALL, yypvt[-3].y_node, yypvt[-1].y_node);
} break;
case 79:
# line 505 "commands.y"
{
 	yyval.y_node = build(O_DEBUG, yypvt[-0].y_long);
} break;
case 80:
# line 510 "commands.y"
{
	yyval.y_node = build(O_DUMP);
} break;
case 81:
# line 515 "commands.y"
{
	yyval.y_node = build(O_STATUS);
} break;
case 82:
# line 521 "commands.y"
{
	yyval.y_node = build(O_ALIAS, build(O_NAME, yypvt[-1].y_name), build(O_NAME, yypvt[-0].y_name));
} break;
case 83:
# line 526 "commands.y"
{
	yyval.y_node = build(O_ALIAS, build(O_NAME, yypvt[-0].y_name), nil);
} break;
case 84:
# line 531 "commands.y"
{
	yyval.y_node = build(O_ALIAS, nil, nil);
} break;
case 85:
# line 537 "commands.y"
{
	yyval.y_op = O_TRACE;
} break;
case 86:
# line 542 "commands.y"
{
	yyval.y_op = O_TRACEI;
} break;
case 87:
# line 548 "commands.y"
{
	yyval.y_op = O_STOP;
} break;
case 88:
# line 553 "commands.y"
{
	yyval.y_op = O_STOPI;
} break;
case 89:
# line 559 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 90:
# line 564 "commands.y"
{
	yyval.y_node = build(O_QLINE, build(O_SCON, yypvt[-2].y_string), yypvt[-0].y_node);
} break;
case 91:
# line 570 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 92:
# line 575 "commands.y"
{
	yyval.y_node = build(O_QLINE, build(O_SCON, cursource), yypvt[-0].y_node);
} break;
case 93:
# line 580 "commands.y"
{
	yyval.y_node = build(O_QLINE, build(O_SCON, yypvt[-2].y_string), yypvt[-0].y_node);
} break;
case 94:
# line 586 "commands.y"
{
	yyval.y_string = ident(yypvt[-0].y_name);
} break;
case 95:
# line 592 "commands.y"
{
	yyval.y_string = nil;
} break;
case 96:
# line 597 "commands.y"
{
	yyval.y_string = yypvt[-0].y_string;
} break;
case 97:
# line 603 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 98:
# line 608 "commands.y"
{
	yyval.y_node = nil;
} break;
case 99:
# line 614 "commands.y"
{
	yyval.y_node = build(O_LIST,
	    build(O_LCON, (long) cursrcline),
	    build(O_LCON, (long) cursrcline + 9)
	);
} break;
case 100:
# line 622 "commands.y"
{
	yyval.y_node = build(O_LIST, yypvt[-0].y_node, yypvt[-0].y_node);
} break;
case 101:
# line 627 "commands.y"
{
	yyval.y_node = build(O_LIST, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 102:
# line 632 "commands.y"
{
	yyval.y_node = build(O_LIST, yypvt[-0].y_node);
} break;
case 103:
# line 638 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 104:
# line 643 "commands.y"
{
	yyval.y_node = build(O_COMMA, build(O_LCON, yypvt[-1].y_long), yypvt[-0].y_node);
} break;
case 105:
# line 649 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 106:
# line 654 "commands.y"
{
	yyval.y_node = build(O_LCON, (long) LASTLINE);
} break;
case 107:
# line 660 "commands.y"
{
	yyval.y_node = build(O_EXAMINE, yypvt[-0].y_string, yypvt[-3].y_node, nil, yypvt[-1].y_long);
} break;
case 108:
# line 665 "commands.y"
{
	yyval.y_node = build(O_EXAMINE, yypvt[-0].y_string, yypvt[-4].y_node, yypvt[-2].y_node, 0);
} break;
case 109:
# line 670 "commands.y"
{
	yyval.y_node = build(O_EXAMINE, yypvt[-0].y_string, build(O_LCON, (long) prtaddr), nil, yypvt[-1].y_long);
} break;
case 110:
# line 675 "commands.y"
{
	yyval.y_node = build(O_EXAMINE, yypvt[-0].y_string, yypvt[-2].y_node, nil, 0);
} break;
case 111:
# line 681 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 112:
# line 686 "commands.y"
{
	yyval.y_node = amper(yypvt[-0].y_node);
} break;
case 113:
# line 691 "commands.y"
{
	yyval.y_node = build(O_ADD, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 114:
# line 696 "commands.y"
{
	yyval.y_node = build(O_SUB, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 115:
# line 701 "commands.y"
{
	yyval.y_node = build(O_MUL, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 116:
# line 706 "commands.y"
{
	yyval.y_node = build(O_INDIR, yypvt[-0].y_node);
} break;
case 117:
# line 711 "commands.y"
{
	yyval.y_node = yypvt[-1].y_node;
} break;
case 118:
# line 717 "commands.y"
{
	yyval.y_long = 1;
} break;
case 119:
# line 722 "commands.y"
{
	yyval.y_long = yypvt[-0].y_long;
} break;
case 120:
# line 728 "commands.y"
{
	yyval.y_string = ident(yypvt[-0].y_name);
	curformat = yyval.y_string;
} break;
case 121:
# line 734 "commands.y"
{
	yyval.y_string = curformat;
} break;
case 122:
# line 740 "commands.y"
{
	yyval.y_node = nil;
} break;
case 123:
# line 745 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 124:
# line 751 "commands.y"
{
	yyval.y_node = build(O_COMMA, yypvt[-0].y_node, nil);
} break;
case 125:
# line 756 "commands.y"
{
	yyval.y_node = build(O_COMMA, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 126:
# line 762 "commands.y"
{
	yyval.y_node = build(O_RVAL, yypvt[-0].y_node);
} break;
case 127:
# line 767 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 128:
# line 772 "commands.y"
{
	yyval.y_node = build(O_TYPERENAME, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 129:
# line 777 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 130:
# line 782 "commands.y"
{
	yyval.y_node = build(O_NEG, yypvt[-0].y_node);
} break;
case 131:
# line 787 "commands.y"
{
	yyval.y_node = amper(yypvt[-0].y_node);
} break;
case 132:
# line 792 "commands.y"
{
	yyval.y_node = build(O_ADD, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 133:
# line 797 "commands.y"
{
	yyval.y_node = build(O_SUB, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 134:
# line 802 "commands.y"
{
	yyval.y_node = build(O_MUL, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 135:
# line 807 "commands.y"
{
	yyval.y_node = build(O_DIVF, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 136:
# line 812 "commands.y"
{
	yyval.y_node = build(O_DIV, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 137:
# line 817 "commands.y"
{
	yyval.y_node = build(O_MOD, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 138:
# line 822 "commands.y"
{
	yyval.y_node = build(O_AND, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 139:
# line 827 "commands.y"
{
	yyval.y_node = build(O_OR, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 140:
# line 832 "commands.y"
{
	yyval.y_node = build(O_LT, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 141:
# line 837 "commands.y"
{
	yyval.y_node = build(O_LE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 142:
# line 842 "commands.y"
{
	yyval.y_node = build(O_GT, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 143:
# line 847 "commands.y"
{
	yyval.y_node = build(O_GE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 144:
# line 852 "commands.y"
{
	yyval.y_node = build(O_EQ, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 145:
# line 857 "commands.y"
{
	yyval.y_node = build(O_EQ, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 146:
# line 862 "commands.y"
{
	yyval.y_node = build(O_NE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 147:
# line 867 "commands.y"
{
	yyval.y_node = build(O_NE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 148:
# line 872 "commands.y"
{
	yyval.y_node = yypvt[-1].y_node;
} break;
case 149:
# line 878 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 150:
# line 883 "commands.y"
{
	yyval.y_node = subscript(yypvt[-3].y_node, yypvt[-1].y_node);
} break;
case 151:
# line 888 "commands.y"
{
	yyval.y_node = dot(yypvt[-2].y_node, yypvt[-0].y_name);
} break;
case 152:
# line 893 "commands.y"
{
	yyval.y_node = dot(yypvt[-2].y_node, yypvt[-0].y_name);
} break;
case 153:
# line 898 "commands.y"
{
	yyval.y_node = build(O_INDIR, yypvt[-0].y_node);
} break;
case 154:
# line 903 "commands.y"
{
	yyval.y_node = build(O_INDIR, yypvt[-1].y_node);
} break;
case 155:
# line 908 "commands.y"
{
	yyval.y_node = build(O_INDIR, yypvt[-1].y_node);
} break;
case 156:
# line 913 "commands.y"
{
	yyval.y_node = concrete(yypvt[-0].y_node);
} break;
case 157:
# line 918 "commands.y"
{
	yyval.y_node = concrete(yypvt[-1].y_node);
} break;
case 158:
# line 923 "commands.y"
{
	yyval.y_node = build(O_CALL, yypvt[-3].y_node, yypvt[-1].y_node);
} break;
case 159:
# line 929 "commands.y"
{
	chkboolean(yypvt[-0].y_node);
	yyval.y_node = yypvt[-0].y_node;
} break;
case 160:
# line 936 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 161:
# line 941 "commands.y"
{
	yyval.y_node = build(O_FCON, yypvt[-0].y_real);
} break;
case 162:
# line 946 "commands.y"
{
	yyval.y_node = build(O_SCON, yypvt[-0].y_string);
} break;
case 163:
# line 952 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 164:
# line 957 "commands.y"
{
	yyval.y_node = dot(yypvt[-2].y_node, yypvt[-0].y_name);
} break;
case 165:
# line 963 "commands.y"
{
	yyval.y_node = build(O_SYM, which(yypvt[-0].y_name));
} break;
case 166:
# line 968 "commands.y"
{
	yyval.y_node = dot(build(O_SYM, program), yypvt[-0].y_name);
} break;
case 167:
# line 974 "commands.y"
{
	yyval.y_name = yypvt[-0].y_name;
} break;
case 168:
# line 979 "commands.y"
{
	yyval.y_name = yypvt[-0].y_name;
} break;
		}
		goto yystack;  /* stack new state and value */

	}
