#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

struct hdr {
	short	*lowpc;
	short	*highpc;
	int	ncount;
};

struct cnt {
	unsigned cvalue;
	long	cncall;
};

FILE *efopen();

main(argc, argv)
int argc;
char *argv[];
{
	char *outf = "mon.out";

	if (argc < 3) {
		printf("usage: %s mon1file mon2file difffile\n", argv[0]);
		exit(1);
	}
	if (argc == 4)
		outf = argv[3];
	diff(argv[1], argv[2], outf);
}

diff(m1, m2, md)
char *m1, *m2, *md;
{
	FILE *fp1, *fp2, *fpd;
	struct cnt c1, c2, c3;
	short h1, h2, h3;
	struct hdr h;
	struct stat stb;
	int histcnt;

	fp1 = efopen(m1, "r");
	fp2 = efopen(m2, "r");
	fpd = efopen(md, "w");
	efread((char *)&h, sizeof h, 1, fp1);
	efwrite((char *)&h, sizeof h, 1, fpd);
	efread((char *)&h, sizeof h, 1, fp2);	/* just to line up the fp's */
	while(h.ncount > 0) {
		efread((char *)&c1, sizeof c1, 1, fp1);
		efread((char *)&c2, sizeof c2, 1, fp2);
		if ((c3.cvalue = c1.cvalue) && c1.cvalue != c2.cvalue)
			fatal("mon file consistency problem");
		c3.cncall = c2.cncall - c1.cncall;
		efwrite((char *)&c3, sizeof c3, 1, fpd);
		h.ncount--;
	}
	fstat(fileno(fp1), &stb);
	histcnt = (stb.st_size - ftell(fp1))/sizeof(short);
	while(histcnt > 0) {
		efread((char *)&h1, sizeof h1, 1, fp1);
		efread((char *)&h2, sizeof h2, 1, fp2);
		h3 = h2 - h1;
		efwrite((char *)&h3, sizeof h3, 1, fpd);
		histcnt--;
	}
	fclose(fp1);
	fclose(fp2);
	fclose(fpd);
	return(0);
}

efread(ptr, size, nitems, stream)
char *ptr;
int size, nitems;
FILE *stream;
{
	if (fread(ptr, size, nitems, stream) == 0)
		fatal("efread failed");
}
efwrite(ptr, size, nitems, stream)
char *ptr;
int size, nitems;
FILE *stream;
{
	if (fwrite(ptr, size, nitems, stream) == 0)
		fatal("efwrite failed");
}

FILE *
efopen(filename, type)
char *filename, *type;
{
	FILE *rc;

	if ((rc = fopen(filename, type)) == NULL)
		fatal("efopen failed");
	return(rc);
}

fatal(s)
char *s;
{
	fprintf(stderr, "%s\n", s);
	exit(1);
}
