/*
 * Stopwatch to measure process CPU usage
 */

#define mask(x) (x&0377)
#include <sys/param.h>
#include <sys/conf.h>
#include <nlist.h>
#include <sys/ttyio.h>
#include <sys/dir.h>
#include <sys/signal.h>
#include <sys/seg.h>
#include <sys/user.h>
#include <sys/times.h>
#include <sys/proc.h>

char	*fcore	= "/dev/kmem";
char	*fnlist	= "/unix";
int	fc;

struct	nlist setup[] = {
#define	SINODE	0
	{ "_inode"},
#define	STEXT	1
	{"_text" },
#define	SPROC	2
	{ "_proc" },
#define	STTY	3
	{ "_tty" },
#define	SNDH	4
	{ "_ndh11" },
#define	SKL	5
	{ "_constty" },
#define	SFIL	6
	{ "_file" },
#define	SMOUNT	7
	{ "_mount" },
#define	SSWAPMAP	8
	{ "_swapmap" },
#define	SCOREMAP	9
	{ "_cormap" },
#define	SSID		10
	{ "_sid" },
#define	SMESG		11
	{ "_mesg" },
	0
};

struct us {
	u_int	pid;
	int	usrtm;
	int	systm;
	char cmd[DIRSIZ];
} before[NPROC], after[NPROC];


main(argc, argv)
char **argv;
{

	int i;
	char s[256];
	time_t ts;
	struct tms t;

	if ((fc = open(fcore, 0)) < 0) {
		printf("Can't find %s\n", fcore);
		exit(1);
	}
	nlist(fnlist, setup);
	if (setup[SINODE].n_type == -1) {
		printf("no namelist\n");
		exit(1);
	}
	getproc(before, NPROC);
	ts = times(&t);
	printf("timer started:press return when done:");
	gets(s);
	getproc(after, NPROC);
	diffem(before, after);
	printf("Clock time = \t%d ms\n", (times(&t) - ts)*17);
}
putf(v, n)
{
	if (v)
		printf("%c", n);
	else
		printf(" ");
}

getproc(sp, num)
struct us *sp;
int num;
{
	struct proc xproc[NPROC];
	register struct proc *pp;
	register struct us *cp, *ep;
	register loc, np;

	cp = sp;
	ep = sp + num;
	kseek(fc, (long)setup[SPROC].n_value, 0);
	read(fc, (char *)xproc, sizeof(xproc));
	np = 0;
	for (pp=xproc; pp < &xproc[NPROC]; pp++)
		if (pp->p_stat)
			np++;
	printf("%d processes\n", np);
	for (loc=setup[SPROC].n_value,pp=xproc; pp<&xproc[NPROC]; pp++,loc+=sizeof(xproc[0])) {
		if (pp->p_stat==0)
			continue;
		if (cp < ep) {
			cp->pid = pp->p_pid;
			getuinfo(cp, ctob((unsigned)pp->p_addr));
		} else
			return(-1);
		cp++;
	}
	cp->usrtm = (int)~0;
}



kseek(fd, offset, how)
{
	return lseek(fd, offset & ~0xC0000000, how);
}
getuinfo(p, addr)
struct us *p;
int addr;
{
	union {
		struct  user rxu;
		char    fxu[USIZE << BPCSHIFT];
	} xu;
	register struct user *up;
	register i;

	kseek(fc, addr, 0);
	read(fc, (char *)&xu, sizeof(xu));
	up = &xu.rxu;
	p->usrtm = up->u_utime;
	p->systm = up->u_stime;
	if (*p->cmd == 0)
		memcpy(p->cmd, up->u_comm, DIRSIZ);
}

diffem(bp, ap)
struct us *bp, *ap;
{
	struct us *p;
	int ut, st;

	printf("PID\tUSER\tSYSTEM\tCOMMAND\n");
	while(bp->usrtm != (int)~0) {
		p = ap;
		do {
			if (p->pid == bp->pid) {
				ut = (p->usrtm-bp->usrtm)*16;
				st = (p->systm-bp->systm)*16;
				printf("%d\t%d\t%d\t%s\n",
					bp->pid, ut, st, bp->cmd);
				break;
			}
			p++;
		} while(p->usrtm != (int)~0);
		bp++;
	}
}
