/*
 * Stopwatch to measure process CPU usage
 */

#define mask(x) (x&0377)
#include <sys/param.h>
#include <sys/conf.h>
#include <nlist.h>
#include <sys/ttyio.h>
#include <sys/dir.h>
#include <sys/signal.h>
#include <sys/seg.h>
#include <sys/user.h>
#include <sys/times.h>
#include <sys/proc.h>

char	*fcore	= "/dev/kmem";
char	*fnlist	= "/unix";
int	fc;
int na, nb, ttime, tusr, tsys;
tcmp();

struct	nlist setup[] = {
#define	SINODE	0
	{ "_inode"},
#define	STEXT	1
	{"_text" },
#define	SPROC	2
	{ "_proc" },
#define	STTY	3
	{ "_tty" },
#define	SNDH	4
	{ "_ndh11" },
#define	SKL	5
	{ "_constty" },
#define	SFIL	6
	{ "_file" },
#define	SMOUNT	7
	{ "_mount" },
#define	SSWAPMAP	8
	{ "_swapmap" },
#define	SCOREMAP	9
	{ "_cormap" },
#define	SSID		10
	{ "_sid" },
#define	SMESG		11
	{ "_mesg" },
	0
};

struct us {
	u_int	pid;
	int	usrtm;
	int	systm;
	char cmd[DIRSIZ];
} before[NPROC], after[NPROC];	/* before becomes the difference in diffem */


main(argc, argv)
char **argv;
{

	int i;
	char s[256];
	time_t ts;
	struct tms t;

	if ((fc = open(fcore, 0)) < 0) {
		printf("Can't find %s\n", fcore);
		exit(1);
	}
	nlist(fnlist, setup);
	if (setup[SINODE].n_type == -1) {
		printf("no namelist\n");
		exit(1);
	}
	nb = getproc(before, NPROC);
	ts = times(&t);
	printf("timer started:press return when done:");
	gets(s);
	na = getproc(after, NPROC);
	diffem(before, after);
	printem(before);
	printf("Clock time = \t%d ms\n", (times(&t) - ts)*17);
}

getproc(sp, num)
struct us *sp;
int num;
{
	struct proc xproc[NPROC];
	register struct proc *pp, *pe;
	register struct us *cp, *ep;
	register loc, np;

	cp = sp;
	ep = sp + num;
	kseek(fc, (long)setup[SPROC].n_value, 0);
	read(fc, (char *)xproc, sizeof(xproc));
	np = 0;
	pe = &xproc[NPROC];
	for (pp=xproc; pp < pe;pp++)
		if (pp->p_stat)
			np++;
	printf("%d processes\n", np);
	for (loc=setup[SPROC].n_value,pp=xproc; pp<pe; pp++,loc+=sizeof(xproc[0])) {
		if (pp->p_stat==0)
			continue;
		if (cp < ep) {
			cp->pid = pp->p_pid;
			getuinfo(cp, ctob((unsigned)pp->p_addr));
		} else
			return(-1);
		cp++;
	}
	cp->usrtm = -1;
	return(np);
}



kseek(fd, offset, how)
{
	return lseek(fd, offset & ~0xC0000000, how);
}
getuinfo(p, addr)
struct us *p;
int addr;
{
	union {
		struct  user rxu;
		char    fxu[USIZE << BPCSHIFT];
	} xu;
	register struct user *up;
	register i;

	kseek(fc, addr, 0);
	read(fc, (char *)&xu, sizeof(xu));
	up = &xu.rxu;
	p->usrtm = up->u_utime;
	p->systm = up->u_stime;
	if (*p->cmd == 0)
		memcpy(p->cmd, up->u_comm, DIRSIZ);
}

diffem(bp, ap)
struct us *bp, *ap;
{
	struct us *p, *q;

	q = bp;
	while(q->usrtm != -1) {
		p = ap;
		do {
			if (p->pid == q->pid) {
				q->usrtm = (p->usrtm-q->usrtm)*16;
				q->systm = (p->systm-q->systm)*16;
				ttime += q->usrtm + q->systm;
				tusr += q->usrtm;
				tsys += q->systm;
				break;
			}
			p++;
		} while(p->usrtm != -1);
		q++;
	}
	qsort(bp, nb, sizeof(struct us), tcmp);
}
tcmp(p1, p2)
struct us *p1, *p2;
{
	return((p1->usrtm+p1->systm)-(p2->usrtm+p2->systm));
}
printem(bp)
struct us *bp;
{
	int tt;
	struct us *bpe;

	printf("%6.6s  %8.8s  %8.8s  %9.9s  %3.3s  %s\n",
	"PID","USER","SYSTEM","TOTAL","%","COMMAND");
	bpe = bp + nb;
	while (bp < bpe) {
		tt = bp->systm + bp->usrtm;
		printf("%6d  %8d  %8d  %9d  %3d  %s\n",
			bp->pid, bp->usrtm, bp->systm,
			tt, tt*100/ttime, bp->cmd);

		bp++;
	}
	printf("total:  %8d  %8d\n", tusr, tsys);
}
