/*	tftp.h	4.1	82/08/16	*/

/*
 * Trivial File Transfer Protocol (IEN-133)
 */
#define	SEGSIZE		512		/* data segment size */
#define	TIMEOUT		5		/* retransmits every 5 seconds */
#define	MAXTIMEOUT	(5*TIMEOUT)	/* abort if no success by then */

/*
 * Packet types.
 */
#define	RRQ	01			/* read request */
#define	WRQ	02			/* write request */
#define	DATA	03			/* data packet */
#define	ACK	04			/* acknowledgement */
#define	ERROR	05			/* error code */

struct	tftphdr {
	union {
	struct {
		short	opcode;
		char	stuff[2];	/* filename, mode */
	} rq;				/* request packet */
	struct	{
		short	opcode;
		short	block;		/* block number of this data */
		short	data[1];	/* data for transfer */
	} data;
	struct	{			/* ack packet */
		short	opcode;
		short	block;
	} ack;
	struct	{
		short	opcode;
		short	errcode;
		short	data[1];
	} error;
	} U;
};

#define	th_block	U.data.block
#define	th_code		U.error.errcode
#define	th_stuff	U.rq.stuff
#define	th_msg		U.data.data
#define	th_data		U.data.data
#define	th_opcode	U.rq.opcode
#define	th_data		U.data.data

/*
 * Error codes.
 */
#define	EUNDEF		0		/* not defined */
#define	ENOTFOUND	1		/* file not found */
#define	EACCESS		2		/* access violation */
#define	ENOSPACE	3		/* disk full or allocation exceeded */
#define	EBADOP		4		/* illegal TFTP operation */
#define	EBADID		5		/* unknown transfer ID */
#define	EEXISTS		6		/* file already exists */
#define	ENOUSER		7		/* no such user */
