/* q.c */
#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <sys/ethernet.h>
#include <sys/ipm.h>
#include "pep.h"
#include "malloc.h"

extern int dbg;
static struct qtop *top;
char errstr[128];
char *ascii2hex();
struct b *balloc(), *bfree();
static char addr1[] = {0x22, 0x00, 0x00, 0x00, 0x00, 0x00};
static char addr2[] = {0x23, 0x00, 0x00, 0x00, 0x00, 0x00};

struct b blocks[NUMBLKS];

int 
resend() /*scan the q heads and resend as needed*/
{
	register struct qtop *p;

	p = top;
	while (p) {
		if (p->size > 0) {
			if (p->resends >= MAX_RESENDS) {
				if (retmsg(p->scope, p->curr_trid) >= 0) {
					sendtop(p->scope);
	
						sprintf(errstr,
						"max resends for %d\n",
						p->scope);
						err(errstr);
				} else
					err("remtop error\n");
			} else
				if (p->timeo++ >= MAX_TIMEO) {
					p->timeo = 0;
					if (sendagain(p->scope) < 0)
						err("pep:sendagain() failed\n");
					p->resends++;
				}
		}
		p = p->next;
	}
}

/* Different from sendtop because the trid is not incremented*/
static int 
sendagain(scope)
u_short scope;
{
        register struct qtop *p;
	int n;

        p = top;
	err("sendagain\n");
        while(p != NULL && p->scope != scope)
                p = p->next;
        if (p != NULL && p->head) {
		p->head->block.trid = p->curr_trid;
		n = sizeof(struct eblk) - MAX_DATA + p->head->block.mh.length;
		etherwrite(p->head, n);
        } else
                return(-1);
}

int 
sendtop(scope)
u_short scope;
{
        register struct qtop *p;
	int n;

        p = top;
	err("sendagain\n");
        while(p != NULL && p->scope != scope)
                p = p->next;
        if (p != NULL && p->head) {
		p->head->block.trid = ++p->curr_trid;
		n = sizeof(struct eblk) - MAX_DATA + p->head->block.mh.length;
		etherwrite(p->head, n);
        } else
                return(-1);
}

int 
remtop(scope, trid)/*remove top member from the specified q*/
u_short scope;
u_int trid;
{
	register struct qtop *p;
	register struct b *tmp;

	p = top;
	if (dbg)
		printf("pep:remtop:p = %x\n", p);
	while(p != NULL && p->scope != scope)
		p = p->next;
	if (p != NULL && p->head) {
		tmp = p->head;
		if (p->curr_trid == trid) {
			p->head = tmp->next;
			if (p->head == NULL)
				p->tail = p->head;
			bfree(tmp);
			p->resends = 0;
			p->timeo = 0;
			return(--p->size);
		} else {
			/* this is a duplicate ACK */
			err("q.c duplicat ack received\n");
			return(-1);
		}
	} else
		return(0);
}
int
retmsg(scope, trid)
u_short scope;
u_int trid;
{
	register struct qtop *p;
	register struct b *tmp;
	struct mesghdr m;
	char *dp;

	p = top;
	while(p != NULL && p->scope != scope)
		p = p->next;
	if (p != NULL && p->head) {
		tmp = p->head;
		if (p->curr_trid == trid) {
			p->head = tmp->next;
			if (p->head == NULL)
				p->tail = p->head;
			dp = msgalloc(tmp->block.mh.length);
			bcopy(&tmp->block.mh.orig, &m.dest, sizeof m.dest);
			bcopy(&tmp->block.mh.dest, &m.orig, sizeof m.orig);
			m.flags = tmp->block.mh.flags | MESG_RETURNED;
			m.length = tmp->block.mh.length;
			bcopy(tmp->block.data, dp, m.length);
			if (msgsend(&m, dp) < 0) {
				perror("pep:msgsend");
				msgfree(dp);
			}
			p->resends = 0;
			p->timeo = 0;
			return(--p->size);
		} else {
			/* this is a duplicate ACK */
			err("q.c duplicat ack received\n");
			return(-1);
		}
	} else
		return (0);
}

int 
pepsend(msgh, data)/*add the member to the xmit q and send if on the top*/
register struct mesghdr *msgh;
char *data;
{
	int a;

	switch(addm(msgh, data)) {
	case 1:
		sendtop(msgh->dest.scope);
		break;
	case -1:
		bounce(msgh, data);
		break;
	default:
		/* do nothing */
		break;
	}
}

static struct qtop *
new_top(msgh) /*make a new q head for the specified scope*/
register struct mesghdr *msgh;
{
	register struct qtop *s;

	s = (struct qtop *)calloc(1, sizeof(struct qtop));
	s->scope = msgh->dest.scope;
	return(s);
}

static int 
scope2enet(dh, scope)/*uses algorithm to cvt a scope to enet*/
register u_char *dh;
u_short scope;
{
	u_short *pidp;

	pidp = (u_short *)&dh[4];

	if (scope & 0x4000) {
		memcpy(dh, addr2, ETHERALEN);
		*pidp = scope;
	} else {
		memcpy(dh, addr1, ETHERALEN);
		*pidp = scope;
	}
}

static int 
addm(msgh, adata)/*add a message to the xmt q and return the q size*/
struct mesghdr *msgh;
register char *adata;
{
	register struct qtop *p, *tmp;
	register struct b *bp;
	int n;

	if ((bp = balloc()) == 0)
		return(-1);
	scope2enet(bp->block.dhost, msgh->dest.scope);
	bp->block.type = PEP_ETYPE;
	bp->block.pep_type = PEP_DATA;
	bcopy(msgh, &bp->block.mh, sizeof(struct mesghdr));
	n = min(MAX_DATA, bp->block.mh.length);
	bcopy(adata, bp->block.data, n);
	bp->next = NULL;
	p = top;
	while(p) {
		if (msgh->dest.scope == p->scope) {
			if (p->head == NULL && p->tail == NULL){
				p->head = bp;
				p->tail = bp;
				p->size = 1;
			} else {
				p->tail->next = bp;
				p->tail = bp;
				p->size++;
			}
			return(p->size);
		}
		p = p->next;
	}
	p = new_top(msgh);
	p->head = bp;
	p->tail = bp;
	p->size = 1;
	if (top) {
		tmp = top;
		top = p;
		p->next = tmp;
	} else
		top = p;
	return(p->size);
}

/*debugging only...prints the transmit q
printq()
{
	struct qtop *p;
	struct memb *q;
	p = top;
	while (p) {
		q = p->head;
		do {
			if (q)
				q = q->next;
		} while (q);
		p = p->next;
	}
}
*/

static 
hex(x) /*cvt an ascii char to a hex number*/
char x;
{
	switch (x)
	{
		case '0': return(0);
		case '1': return(1);
		case '2': return(2);
		case '3': return(3);
		case '4': return(4);
		case '5': return(5);
		case '6': return(6);
		case '7': return(7);
		case '8': return(8);
		case '9': return(9);
		case 'a': return(10);
		case 'b': return(11);
		case 'c': return(12);
		case 'd': return(13);
		case 'e': return(14);
		case 'f': return(15);
		default:
			(void)printf("bad hex char = %c\n",x);
			exit(-1);
	}
}

static char *
ascii2hex(ret, instring)/*cvt an ascii enet string to a binary addr*/
register char *ret;
register char *instring;
{
	register int i;

	for (i=0;i<6;i++)
		ret[i] = hex(*instring++) + 16 * hex(*instring++);
}

min(a,b)        {return a< b ? a : b; }

struct b *
balloc()
{
	register struct b *p, *end;
	end = &blocks[NUMBLKS];
	for (p = blocks; p < end; p++)
		if (p->flags == 0) {
			p->flags = 1;
			return(p);
		}
	return(-1);
}

struct b *
bfree(b)
struct b *b;
{
	return(b->flags = 0);
}

bounce(mh, d)
struct mesghdr *mh;
char *d;
{
	struct mesghdr nmh;

	bcopy(&mh->orig, &nmh.dest, sizeof nmh.dest);
	bcopy(&mh->dest, &nmh.orig, sizeof nmh.orig);
	nmh.flags = mh->flags | MESG_RETURNED;
	nmh.length = mh->length;
	if (msgsend(&nmh, d) < 0) {
		perror("pep:msgsend");
		msgfree(d);
	}
}
