/* mcount.s: count subroutine calls during profiling */

/* Each function has a pointer to a count record.
 * A count record has the following structure:
 *	struct {
 *		char *funcp;
 *		int   count;
 *	};
 * Space for count records are provided by the mcrt0 routine.
 * Countbase points to the next availible count record.
 * If countbase is null, don't do any counting.
 */

	.globl	mcount
	.comm	countbase,4
 mcount:
	movl	a1@, a0			/* address of func counter */
	cmpl	#0, a0
	bnes	1f			/* if already inited then goto count */
	movl	countbase,a0		/* else set up new count record */
	cmpl	#0, a0
	beq	2f			/*   if no countbase address, exit */
	addl	#8,countbase		/*   alloc new count record */
	movl	sp@, a0@+		/*   fill in func address */
	movl	a0, a1@			/*   set func's ptr to cnt rcd */
1:
	addl	#1, a0@			/* count this entry */
2:
	rts
