/* signal(n, 0); 	/* default action on signal (n) */
/* signal(n, odd);		/* ignore signal(n) */
/* signal(n, label);		/* goto label on signal(n) */

	.set	NSIG,20
	.set	nowhere,0

	.globl	_dvect
	.globl	_signal, cerror
_signal:
	link	a6,#0
	movl	a6@(8),d0
	cmpl	#NSIG,d0
	bgts	2f
	
	movl	a6@(12),d1 	/* get label */
	lea	dvect,a0
	lsll	#2,d0		/* scale */
	addl	d0,a0		/* offset into vectors */
	lsrl	#2,d0		/* get nsig back */
	movl	a0@,sp@-	/* push old label on stack */
	movl	d1,a0@		/* save new label in table */
	movl	d1,a0		/* this could be the label arg */
	beqs	1f		/* addr of 0 means default */
	btst	#0,d1		/* is it odd ? */
	bnes	1f		/* odd, let it through */
	lea	sigcat,a0	/* This will be the label arg */
1:
	movl	a0,sp@-		/* push label */
	movl	d0,sp@-		/* push nsig */
	movl	#48,d0
	movl	#0,sp@-		/* trash where the RA used should be */
	trap	#0		/* SVC */
	bcss	3f		/* oops */
	addl	#12,sp		/* trash RA, label and nsig from stack */
	movl	sp@+,d0		/* old label */
	unlk	a6
	rts

2:				/* reject the signal */
	movl	#22,d0
3:
	addl	#16,sp
	unlk	a6
	jmp	cerror


sigcat:				/* catch the signal here first */
	movml	#0xC0C0,sp@-	/* save a0,a1,d0,d1 */
	movl	sp@(16),d0
	movl	d0,sp@-		/* push the signal number as the argument */
	lsll	#2,d0		/* scale */
	lea	dvect,a1
	addl	d0,a1
	movl	a1@,a0
	jsr	a0@
	addql	#4,sp		/* clean stack */
	movml	sp@+,#0x0303	/* restore registers */
	addql	#8,sp		/* pop signal and arg */
	movw	sp@+,sp@	/* pop sr and stick in where trap type was */
	rtr
	.data
dvect:
	.space NSIG * 4
	.align	1
	.text
	.set	_dvect,dvect
