/* rcmd.c:  10th edition style remote command execution fuction */
#include <sys/inio.h>
#include <sys/inet/tcp_user.h>

tcp_rcmd(host, port, locuser, remuser, cmd, fd2p)
	char *host, *locuser, *remuser, *cmd;
	char *port;
	int *fd2p;
{
	register fd;
	struct tcpuser tu;
	char c;

	tu.fport = atoi(port);
	if ((tu.faddr = in_address(host)) == 0) 
		return -1;
	if ((fd = tcp_sock()) == -1)
		return -1;
	tu.laddr = INADDR_ANY;
	tu.lport = 1023;
	for (;;) {		/* try various proctected lports */
		if (--tu.lport == 512)
			return -1;
		if (tcp_connect(fd, &tu) == 0)
			break;
		if (tu.code != TCPC_BOUND)
			return -1;
	}
	/* ignore fd2p for now */
	write(fd, "", 1);
	write(fd, locuser, strlen(locuser)+1);
	write(fd, remuser, strlen(remuser)+1);
	write(fd, cmd, strlen(cmd)+1);
	if (read(fd, &c, 1) != 1) {
		perror(host);
		close(fd);
		return -1;
	}
	if (c != 0) {
		while (read(fd, &c, 1) == 1) {
			write(2, &c, 1);
			if (c == '\n')
				break;
		}
		close(fd);
		return -1;
	}
	return fd;
}
