/*
 *	tunable variables
 */

#define	NBUF	200		/* size of buffer cache */
#define	NINODE	250		/* number of incore inodes */
#define	NFILE	400		/* number of incore file structures */
#define	NMOUNT	10		/* number of mountable file systems */
#define	MAXMEM	4096		/* max core per process in clicks */
#define	MAXUPRC	25		/* max processes per user */
#define	SSIZE	3		/* initial stack size */
#define	SINCR	3		/* increment of stack  */
#define	NOFILE	128		/* max open files per process */
#define	CANBSIZ	256		/* max size of typewriter line */
#define	CMAPSIZ	200		/* size of core allocation area */
#define	SMAPSIZ	200		/* size of swap allocation area */
#define	NCALL	30		/* max simultaneous time callouts */
#define	NPROC	150		/* max number of prcesses */
#define	NTEXT	40		/* max number of pure texts */
#define	NCLIST	100		/* max total clist size */
#define	NPTE	(64*1024/512)	/* max per user message space */
#define	NMESG		1000	/* number of message clicks */
#define	HZ	60		/* ticks/second of the clock */
#define	TIMEZONE	(8*60)
#define	DSTFLAG	1		/* Daylight saving time applies */
#define	MSGBUFS	1024		/* characters saved for error messages */
#define	NCARGS	5120		/* # characters in exec arglist */
#define	NSIDS	100		/* # of adaptive ipc service ids */
#define	NMSGS	1000		/* # of adaptvie message headers */
#define	NQUEUES	300		/* # of stream queues */
#define	NSTREAMS 128		/* # of steam heads */
#define	NBLOCKS	350		/* # of block headers */
#define	NBLBUFS	100		/* # of 4k blocks to start with */
#define	NROUTE	100		/* # of route table entrys */

/*
 * fundamental variables
 * don't change too often
 */

#define	MAXPID	30000		/* max process id */
#define	MAXUID	60000		/* max user id */
#define	MAXLINK	1000		/* max links */

extern maxpmem;
#define	MAXBLK		125	/* max blocks possible for phys IO */
#define	USIZE		7	/* size of user block (*512 bytes) */
#define	USRSTACK	(0x03000000)

#define	CANBSIZ	256		/* max size of typewriter line	*/
#define	HZ	60		/* Ticks/second of the clock */
#define	NCARGS	5120		/* # characters in exec arglist */

/*
 * priorities
 * should not be altered too much
 */

#define	PMASK	0177
#define	PCATCH	0400
#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	39
#define	PUSER	60
#define	PIDLE	127

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBBY	8		/* number of bits per byte */
#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define	BSIZE	512		/* size of file system block (bytes) */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	0777		/* BSIZE-1 */
#define	INOPB	8		/* inodes per block */
#define	INOSHIFT	3	/* LOG2(INOPB) if exact */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */
#define	NICFREE	50		/* number of superblock free blocks */
#define	NCPS	(1<<15)		/* Number of clicks per segment */
#define	NBPC	512		/* Number of bytes per click */
#define	NDPC	1		/* Number of disc blocks per click */
#define	BPCSHIFT	9	/* LOG2(NBPC) if exact */
#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	NODEV	(dev_t)(-1)
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#define	SUPERB	((daddr_t)1)	/* physical block number of the super block */
#define	SUPERBOFF	512	/* byte offset of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#define	NICINOD	100		/* number of superblock inodes */
#define	CBSIZE	28		/* sizeof cblock should be 32 */
#define	CROUND	037		/* clist rounding: sizeof (int *) + CBSIZE -1*/

#define	UMODE	PS_CUR		/* usermode bits */
#define	USERMODE(ps)	((ps & UMODE) == 0)

#define	BASEPRI(ps)	((ps & PS_IPL) != 0)


#define	lobyte(X)	(((unsigned char *)&X)[1])
#define	hibyte(X)	(((unsigned char *)&X)[0])
#define	loword(X)	(((unsigned short *)&X)[1])
#define	hiword(X)	(((unsigned short *)&X)[0])
/*
 * Some macros for units conversion
 */
/* Core clicks to segments and vice versa */
#define ctos(x) ((x+(NCPS-1))/NCPS)
#define	stoc(x) ((x)*NCPS)

/* Core clicks to disk blocks and vice versa */
#define	ctod(x) (x)
#define dtoc(x) (x)

/* inumber to disk address */
#define	itod(x)	(daddr_t)(((unsigned)x+(2*INOPB-1))>>INOSHIFT)

/* inumber to disk offset */
#define	itoo(x)	(int)(((unsigned)x+(2*INOPB-1))&(INOPB-1))

/* clicks to bytes */
#define	ctob(x)	((unsigned)(x)<<BPCSHIFT)

/* bytes to clicks */
#define	btoc(x)	(((unsigned)(x)+(NBPC-1))>>BPCSHIFT)
#define	btoct(x)	((unsigned)(x) >> BPCSHIFT)

#ifndef _TYPES_
#include "types.h"
#endif _TYPES_

