/* tcpld.c: the line discipline for tcp */
#include "param.h"
#include "types.h"
#include "stream.h"
#include "in.h"
#include "ip_var.h"
#include "tcp.h"

extern	putq(), srv(), nullsys();
int	tcplqopen(), tcplput();

struct	qinit	tcpl[] = {
/*up*/ { tcplput, nullsys, nullsys, nullsys, 1500, 10 },
/*dn*/ { putq, srv, tcplqopen, nullsys, 1500, 10}
};

struct	queue *tcpldq;		/* the down queue used by tcpdev.c */

tcplqopen(dev, q)
	dev_t dev;
	struct queue *q;
{
	tcpldq = q;		/* just note the down queue */
	return 0;
}

tcplput(q, bp)
	register struct queue *q;
	register struct block *bp;
{
	u_short sum = 0;
	long word;
	int l;
	u_short olds; /* old sum */
	register struct iphdr *ip;
	register struct tcp *t;
	register struct tcb *tp;
	extern struct tcb tcb[];
	struct tcb *tpl;

	if ((bp->class & S_DELIM) == 0) {
		printf ("tcplput: non-delimited\n");
		freeb(bp);
		return;
	}
	if (bp->wptr < bp->rptr + sizeof (struct iphdr)) {
		freeb(bp);
		return;
	}
	ip = (struct iphdr *)bp->rptr;
	l = (ip->ver_ihl & 0xf) << 2;
	t = (struct tcp *)(bp->rptr + l);
	olds = t->chksum;
	t->chksum = 0;
	l = ip->tlen - l;			/* bytes left in rest */
	bp->wptr = bp->rptr + ip->tlen;
	if (bp->wptr > bp->lim) {
		freeb(bp);
		return;
	}
	sum = tcp_dosums(t, ip->src, ip->dest, l);
	if (sum != olds) {
		printf ("chksum error: sum 0x%x, olds 0x%x\n", sum, olds);
		freeb(bp);
		return;
	}
	/* find tcb for this segment */
	tpl = NULL;
	for (tp = tcb; tp < &tcb[NTCB]; tp++)
		if (tp->state != CLOSED)
		if (tp->lport == t->dest)
			if (tp->laddr == ip->dest
			&&  tp->faddr == ip->src
			&&  tp->fport == t->src)
				break;
			else if (tp->state == LISTEN
				&& (tp->laddr == INADDR_ANY
					|| tp->laddr == ip->dest))
				tpl = tp;
	if (tp == &tcb[NTCB]) {
		if (tpl && t->flags & SYN)
			tp = tpl;
		else {
			if ((t->flags & RST) == 0)
				tcp_reset(bp, ip, t, l);	/* smack him one */
			return;
		}
	}
	/* we have found the tcb for this connection */
	tcp_in(tp, bp);
	pr_tcb("tcplput: ", tp);
}


tcp_reset(bp, ip, ti, l)	/* hack to close sun connection */
	register struct block *bp;
	register struct iphdr *ip;
	register struct tcp   *ti;
{
	in_addr x;
	int y, z;

	x = ip->src;
	ip->src = ip->dest;
	ip->dest = x;
	y = ti->src;
	ti->src = ti->dest;
	ti->dest = y;
	z = ti->ack;
	ti->ack = ti->seq;
	ti->seq = z;		/* this used to be z+1 */
	ti->flags |= RST;
	ti->chksum = tcp_dosums(ti, ip->src, ip->dest, l);
	(*tcpldq->qinfo->putp)(tcpldq, bp);
}
