/*
 *	indirect driver for controlling tty.
 */
#include "param.h"
#include "dir.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"
#include "errno.h"
#include "conf.h"
#include "proc.h"

syopen(dev, flag)
{

	if (u.u_ttyp == NULL) {
		u.u_error = ENXIO;
		return;
	}
	(*cdevsw[major(u.u_ttyd)].d_open)(u.u_ttyd, flag);
}

syread(dev)
{

	(*cdevsw[major(u.u_ttyd)].d_read)(u.u_ttyd);
}

sywrite(dev)
{

	(*cdevsw[major(u.u_ttyd)].d_write)(u.u_ttyd);
}

syioctl(dev, cmd, arg, mode)
{

	(*cdevsw[major(u.u_ttyd)].d_ioctl)(u.u_ttyd, cmd, arg, mode);
}
