/* mcrt0.s:  C runtime start routine including monitoring */

	.set	cbufs, 300
	.globl	_monitor
	.globl	_sbrk
	.globl	_write
	.globl	_exit
	.globl	_etext
	.globl	__cleanup
	.globl	countbase
	.globl	_exit
	.globl	start
	.globl	_main
	.globl	_environ
	.globl	_errno

	.data
_environ:
	.long	0

	.text

start:
	movq	#0,d0
	movl	d0,a6

	movl	sp@+,d1		/* pop argc */
	movl	sp,a5
	movl	#0,a5@(-4)
	movl	sp,a0

1:	tstl	a0@+
	jne	1b

	cmpl	a5@,a0
	jlt	2f
	subql	#4,a0
2:	movl	a0,_environ
	
	movl	_environ,sp@-
	movl	a5,sp@-
	movl	d1,sp@-

	/* set up for profiling */

	movl	#_etext, d1
	subl	#eprol, d1
	addl	#7, d1
	asrl	#3, d1			/* # space for 4 byte samples */
	addl	#4*(cbufs+1), d1	/* and the call space */
	movl	#cbufs, sp@-		/* nfuncs */
	movl	d1, sp@-		/* bufsiz */
	asll	#1, d1
	movl	d1, sp@-
	jsr	_sbrk
	addl	#4, sp
	cmpl	#-1, d0
	beqs	9f
	movl	d0, sp@-		/* buffer */
	addl	#12, d0			/* skip low, high and fcnt */
	movl	d0, countbase
	movl	#_etext, sp@-		/* high pc */
	movl	#eprol, sp@-		/* low pc */
	jsr	_monitor
	addl	#20, sp
Start:
	jsr	_main
	addql	#8,sp
	movl	d0,sp@
3:	jsr	_exit
	jra	3b

9:
	movl	#9f-8f, sp@-
	movl	#8f, sp@-
	movl	#2, sp@-
	jsr	_write

	.data
8:	.ascii 	"No space for monitor buffer\n"
9:	.align 1
	.text

_exit:
	jsr	__cleanup
	clrl	sp@-
	jsr	_monitor
	addl	#4, sp
	movl	#1, d0
	trap	#0
	stop	#0
eprol:
	.data
countbase:
	.long
