/* cformat.c:  Format CDC drive. */

char	inq[] = { 0x12, 0, 0, 0, 0, 0 };
char	rs[] = { 3, 0, 0, 0, 6, 0 };
char	mode_sense[] = { 0x1a, 0, 3, 0, 32, 0 };
char	format_unit[] = { 4, 0, 0, 0, 1, 0 };
char	data[1024];
char	junk[2048];

main()
{
	int r;

	inq[4] = 36;
	printf("0x%x\n", 0xabcd);
	r = scsi(0, rs, data, 6, 0);
	printf("Request Sense returned 0x%x\n", r);
	printf("Sense Key 0x%x\n", data[2] & 017);
	if ((r = scsi(0, inq, data, sizeof data, 0)) != 0)
		printf("r was 0x%x\n", r);
	printf("Peripheral Device Type %d\n", data[0]);
	printf("RMB %d\n", data[1] >> 7 & 01);
	printf("Device-Type Qualifier %d\n", data[1] & 0177);
	printf("ECMA Vresion %d\n", data[2] >> 3 & 07);
	printf("ANSI Version %d\n", data[2] & 03);
	putnstr(&data[8], 27);
	r = scsi(0, mode_sense, data, 32, 0);
	printf("r is 0x%x\n", r);
	dump(data, 32);
	printf("Reading a block: ");
	r = scsi(0, format_unit, 0, 0, 0);
	printf("r is 0x%x\n", r);
	for(;;);
}


putnstr(s, n)
	char *s;
{
	while (n--)
		putchar(*s++);
}

dump(s, n)
	char *s;
{
	while (n--)
		printf("%x ", *s++ & 0xff);
}
