/*	@(#)getpwent.c	2.3	SCCS id keyword	*/
#include <whoami.h>
#include <stdio.h>
#include <pwd.h>

#ifdef UCB_PWHASH
#include <sys/types.h>
#include <pwtable.h>
#define	NAMSIZ	8
#endif

static char PASSWD[]	= "/etc/passwd";
static char EMPTY[] = "";
static FILE *pwf = NULL;
static char line[BUFSIZ+1];
static struct passwd passwd;

setpwent()
{
	if( pwf == NULL )
		pwf = fopen( PASSWD, "r" );
	else
		rewind( pwf );
}

endpwent()
{
	if( pwf != NULL ){
		fclose( pwf );
		pwf = NULL;
	}
#ifdef UCB_PWHASH
	endmapent();
#endif
}

static char *
pwskip(p)
register char *p;
{
	while( *p && *p != ':' )
		++p;
	if( *p ) *p++ = 0;
	return(p);
}

struct passwd *
getpwent()
{
	register char *p;

	if (pwf == NULL) {
		if( (pwf = fopen( PASSWD, "r" )) == NULL )
			return(0);
	}
	p = fgets(line, BUFSIZ, pwf);
	if (p==NULL)
		return(0);
	passwd.pw_name = p;
	p = pwskip(p);
	passwd.pw_passwd = p;
	p = pwskip(p);
	passwd.pw_uid = atoi(p);
	p = pwskip(p);
	passwd.pw_gid = atoi(p);
	passwd.pw_quota = 0;
	passwd.pw_comment = EMPTY;
	p = pwskip(p);
	passwd.pw_gecos = p;
	p = pwskip(p);
	passwd.pw_dir = p;
	p = pwskip(p);
	passwd.pw_shell = p;
	while(*p && *p != '\n') p++;
	*p = '\0';
#ifdef UCB_SHELL
	if (p==passwd.pw_shell)
		passwd.pw_shell = UCB_SHELL;
#endif
	return(&passwd);
}

#ifdef UCB_PWHASH
struct	passwd	*
getpwmap(pwt)
struct	pwtable	*pwt;
{
	struct	passwd	*p;

	if( pwt == NULL )
		return(NULL);
	if( pwf == NULL )
		if( (pwf = fopen( PASSWD, "r" )) == NULL )
			return(NULL);
	if( pwt->pwt_loc == 0L )
		rewind( pwf );
	else {
		fseek( pwf, pwt->pwt_loc - 1L, 0 );
		if( getc(pwf) != '\n' )
			return(NULL);
	}
	if( (p = getpwent()) == NULL )
		return(NULL);
	if( p->pw_uid != pwt->pwt_uid )
		return(NULL);
	if( strncmp(p->pw_name, pwt->pwt_name, NAMSIZ) )
		return(NULL);
	return(p);
}
#endif
