.Lc The\ Joseph\ Lister\ Trace\ Package 11
.de Tf
.sp 2v
.ti -.5i
\fB\\$1\fP - 
..
.pp
The trace package is an important tool for interactive debugging of a Lisp
program.
It allows you to examine selected  calls to a function or functions, and
optionally to stop execution of the Lisp program to examine the contents
of variables.
.pp
The trace package is a set of Lisp programs located in the Lisp program 
library (usually in the file /usr/lib/lisp/trace.l).
To load the trace package into Lisp, type
.b "(load 'trace)" .
There are two user callable functions  in the trace package: 
.i trace 
and 
.i untrace .
Both functions are nlambdas (their arguments are not evaluated).
The form of a call to 
.i trace
is 
.br
.tl ''\fB(trace \fIarg1 arg2 ...\fB)\fR''
where the 
.i argi
have one of the following forms:
.in .75i
.Tf "foo"
when foo is entered and exited, the trace information will be printed.
.Tf "(foo break)"
when foo is entered and exited the trace information will be printed.
Also, just after the trace information for foo is printed upon entry,
you will be put in  a special break loop.
The prompt is `T>' and you may type and Lisp expression, and see its
value printed.
The 
.i i th 
argument to the function just called can be accessed as (arg i).
To leave the trace loop, just type ^D and execution will continue.
.Tf "(foo if expression)"
when foo is entered and the expression evaluates to non nil, then the
trace information will be printed for both exit and entry.
If expression evaluates to nil, then no trace information will be
printed.
.Tf "(foo ifnot expression)"
when foo is entered and the expression evaluates to nil, then the
trace information will be printed for both entry and exit.
.Tf "(foo evalin expression)"
when foo is entered and after the entry trace information is printed,
expression will be evaluated. 
Exit trace information will be printed when foo exits.
.Tf "(foo evalout expression)"
when foo is entered, entry trace information will be printed.
When foo exits, and before the exit trace information is printed,
expression will be evaluated.
.Tf "(foo evalinout expression)"
this has the same effect as (trace (foo evalin expression evalout expression)).
