/*	(C) Copyright 1986. THINK Technologies, Inc.  All rights reserved. */	

/* This module translates UNIX I/O style calls to STDIO calls */

#ifndef	_stdioh_
#include	"stdio.h"
#endif

#ifndef	_ctypeh_
#include	"ctype.h"
#endif

#ifndef	_unixh_
#include "unix.h"
#endif

#ifndef	_FileMgr_
#include "FileMgr.h"
#endif

FILE	*unix_fopen();		/* open a file */

Boolean _unix_file_exists(filename)
char *filename;
{
	FILE *who;
	fileParam pb2;
	
			CtoPstr(filename);
			
			pb2.ioFDirIndex = 0;
			pb2.ioNamePtr	= (StringPtr)filename;
			pb2.ioVRefNum	= 0;
			pb2.ioFVersNum	= 0;
			
			if (PBGetFInfo(&pb2,false) == fnfErr)
			{
				PtoCstr(filename); 
				return(false);
			}
 			PtoCstr(filename); 
			return(true);
}


static char *cvtmode(mode,filename)
register int mode;
char *filename;
{
register int i=0;
static char stdmode[5];

	if ((mode & O_EXCL) && (mode & O_CREAT))
		if (_unix_file_exists(filename))
		{
			errno = EEXIST;
			return(NULL);
		}

	switch (mode & (O_RDONLY | O_WRONLY | O_RDWR))
	{
		case O_RDONLY:
			if (mode & O_APPEND)
			{
				errno = EINVAL;
				return (NULL);
			}
			
			if (mode & O_TRUNC)
			{
				stdmode[i++] = 'w';
				stdmode[i++] = '+';
			}
			else
				stdmode[i++] = 'r';
			break;
				
		case O_WRONLY:
			if (mode & O_APPEND)
			{
				if (mode & O_TRUNC)
					stdmode[i++] = 'w';
				else
					stdmode[i++] = 'a';
			}
			else
				stdmode[i++] = 'w';
			break;
				
		case O_RDWR:
nonstdmode:
			if ((mode & O_CREAT) || (mode & O_TRUNC))
				stdmode[i++] = 'w';
			else
			if (mode & O_APPEND)
				stdmode[i++] = 'a';
			else
				stdmode[i++] = 'r';
			
			stdmode[i++] = '+';
			break;
			
		default:
			/* if no mode was selected, append is a legal mode in this
				implementation and is treated as RDWR append */
				
			if (mode & O_APPEND) goto nonstdmode;
				
			errno = EINVAL;
			return (NULL);			
	}

	if (mode & O_BINARY)
		stdmode[i++] = 'b';
		
	stdmode[i++] = '\0';
	
	return (stdmode);
}

static int invalidfildes(fildes)
register int fildes;
{
	if ((fildes >= _NFILE) || (!_file[fildes].InUse))
	{
		errno = EBADF;
		return (1);
	}
	
	return (0);
}	

/* searches thru the file descriptors for a free file
   and returns the file position of a free file. */

static int findfreefileref()
{
register int i;

	for (i=0; i<_NFILE; i++)
		if (! _file[i].InUse)
			return i;

	return (-1);
}

int fread();
int fwrite();

static unsigned int fileop(fildes, buffer, nbytes, op)
register int fildes;
char *buffer;
unsigned nbytes;
unsigned int (*op)();
{
unsigned int actcount;
extern Boolean _unsignedbytes;

	if (invalidfildes(fildes))
		return (-1);

	_unsignedbytes = true;	/* one-shot flag for unsigned nbytes */
	
	if (actcount = (*op)(buffer, sizeof(*buffer), nbytes, &_file[fildes]))
		return (actcount);
	
	/* pdg - 6/10/86 - supposed to return zero on eof, not error! */
	
	if (_file[fildes].last_error == eofErr)
		return (0);
		
	errno = EIO;
	return (-1);
}

#line 0 fileno

int	fileno(who)
register FILE *who;
{
	if ((!who)||(!who->InUse))
		return(-1);
		
	return(who->fileno);
}

#line 0 open

int open(filename, mode)
char *filename;
int mode;
{
char *type;
FILE *who;

	if (findfreefileref() == -1)
	{
		errno = EMFILE;
		return(-1);
	}
	
	if ((type = cvtmode(mode,filename)) == NULL)
		return(-1);
		
	if ((who = unix_fopen(filename, type))==NULL)
	{
		errno = errno == fnfErr ? ENOENT : EACCES;
		return(-1);
	}
		return (who->fileno);
}

#line 0 close

int close(fildes)
register int fildes;
{
	if (invalidfildes(fildes))
		return (-1);
	
	return (fclose(&_file[fildes]));
}


#line 0 read

int read(fildes, buffer, nbytes)
int fildes;
char *buffer;
unsigned nbytes;
{
	return (fileop(fildes, buffer, nbytes, fread));
}

#line 0 write

int write(fildes, buffer, nbytes)
int fildes;
char *buffer;
unsigned nbytes;
{
	return (fileop(fildes, buffer, nbytes, fwrite));
}

#line 0 lseek

long lseek(fildes, offset, offsetmode)
register int fildes;
long int offset;
register unsigned int offsetmode;
{
	if (invalidfildes(fildes))
		return (-1L);
	
	if (offsetmode>2)
	{
		errno = EINVAL;
		return(-1L);
	}
	
	if (fseek(&_file[fildes], offset, offsetmode))
	{
		errno = EIO;
		return (-1L);
	}
	
	return (ftell(&_file[fildes]));
}

/*
		This is an old Unix seek which returns an int instead of a long and
		is commented out unless you really want to bother uncommenting it!

#line 0 seek

int seek(fildes, offset, origin)
int fildes;
register int offset;
int origin;
{
long longoffset;
int neworigin;
	
	longoffset = ((neworigin = origin % 3) == origin) ? offset : (long)offset*512;

	return ((int) lseek(fildes, longoffset, neworigin));
}
*/

#line 0 tell

long tell(fildes)
int fildes;
{
	return (ftell(&_file[fildes]));
}

#line 0 rename

int	rename(old,new)
char *old,*new;
{
ioParam pb;
	
	CtoPstr(old);
	CtoPstr(new);
	pb.ioNamePtr	= (StringPtr)old;
	pb.ioVRefNum	= 0;
	pb.ioVersNum	= 0;
	pb.ioMisc		= new; 
	
	if (PBRename(&pb,false))
	{
		errno = EIO;
		PtoCstr(old);
		PtoCstr(new);
		return(-1);
	}
	
		PtoCstr(old);
		PtoCstr(new);
		
	return(0);
}

#line 0 remove

int	remove(name)
char *name;
{
	ioParam pb;
	
	CtoPstr(name);
	pb.ioNamePtr	= (StringPtr)name;
	pb.ioVRefNum	= 0;
	pb.ioVersNum	= 0;
	
	if (PBDelete(&pb,false))
	{
		errno = EIO;
		PtoCstr(name);
		return(-1);
	}
	PtoCstr(name);
	return(0);
}

#line 0 unlink

int	unlink(name)
char *name;
{
	return(remove(name));
}

#line 0 creat

int creat(filename, mode)
char *filename;
int mode;
{
	return (open(filename, mode | O_CREAT));
}		 


