/*	@(#)test3.c	1.3 89/01/10 NFS Rev 2 Testsuite	*/
/*
 * Test lookup up and down across mount points
 *
 * Uses the following important system calls against the server:
 *
 *	chdir()
 *	getwd()
 *	stat()
 */

#include "tests.h"

int Tflag = 0;		/* print timing */
int Hflag = 0;		/* print help message */
int Fflag = 0;		/* test function only;  set count to 1, negate -t */
int Nflag = 0;		/* Suppress directory operations */

#ifdef ANSI
void usage(void);
void main(int argc, char *argv[]);
#endif

void
usage()
{
	fprintf(stdout, "usage: %s [-htfn] [count]\n", Myname);
	fprintf(stdout, "  Flags:  h    Help - print this usage info\n");
	fprintf(stdout, "          t    Print execution time statistics\n");
	fprintf(stdout, "          f    Test function only (negate -t)\n");
	fprintf(stdout, "          n    Suppress test directory create operations\n");
}

void
main(argc, argv)
	int argc;
	char *argv[];
{
	int count = 250;		/* times to do test */
	int ct;
	struct timeval time;
/*	struct statfs sfsb; */
	struct stat statb;
	char *opts;
	char path[MAXPATHLEN];

	umask(0);
	setbuf(stdout, NULL);
	Myname = *argv++;
	argc--;
	while (argc && **argv == '-') {
		for (opts = &argv[0][1]; *opts; opts++) {
			switch (*opts) {
				case 'h':	/* help */
					usage();
					exit(1);

				case 't':	/* time */
					Tflag++;
					break;
				
				case 'f':	/* funtionality */
					Fflag++;
					break;
				
				case 'n':	/* No Test Directory create */
					Nflag++;
					break;

				default:
					error("unknown option '%c'", *opts);
					usage();
					exit(1);
			}
		}
		argc--;
		argv++;
	}

	if (argc) {
		count = (int) getparm(*argv, 1L, "count");
		argv++;
		argc--;
	}
	if (argc) {
		usage();
		exit(1);
	}

	if (Fflag) {
		Tflag = 0;
		count = 1;
	}

	fprintf(stdout, "%s: lookups across mount point\n", Myname);

	if (!Nflag)
		testdir(NULL);
	else
		mtestdir(NULL);

	if (Tflag) {
		starttime();
	}

	for (ct = 0; ct < count; ct++) {
		if (getwd(path) == NULL) {
			fprintf(stderr, "%s: getwd failed\n", Myname);
			exit(1);
		}
		if (stat(path, &statb) < 0) {
			error("can't stat %s after getwd", path);
			exit(1);
		}
	}

	if (Tflag) {
		endtime(&time);
	}
	fprintf(stdout, "\t%d getwd and stat calls", count * 2);
	if (Tflag) {
		printtimes(&time, 0L);
	}
	fprintf(stdout, "\n");
	complete();
}
