#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"
#include	"../h/em1.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */

/*
** Main routine of EM1-assembler/loader
*/

main(argc, argv)
	int	argc;
	char	**argv;
{
	/*
	 * Usage: ass [-s(s/m/l)] [ [file] [flag] ] ...
	 *   flag -l<string> can be used as an abbreviation of 
	 *        /usr/lib/lib<string>.a
	 */

	progname = argv[0];
	timing(-1);
	if (argc>1 && argv[1][0] == '-' && argv[1][1] == 's') {
		--argc; ++argv;
		getsizes(&((*argv)[2]));
	}
	if (argc <= 1)
		fatal("Insufficient arguments");
	getcore();
	init_files();
	init_vars();
	while ( --argc )
		argument(*++argv);
	finish_up();
	timing(-30000);
	exit(nerrors!=0);
}

int askmore(n) {
	register result;

	/*
	 * This routine asks for a chunk of n bytes core.
	 * It does this by asking the system for it.
	 * If your operating system doesn't provide this,
	 * or if you don't have an operating system it
	 * can be simulated as follows:
	 *
	 * You should have a variable end, containing the address
	 * of the first location not used by this program.
	 *
	 * askmore(n) {
	 *	register result;
	 *
	 *	result = end;
	 *	end =+ n;	/* check overflow
	 *	return(result);
	 * }
	 *
	 */
	result = int_cast sbrk(n);
	if (result == -1)
		fatal("out of core");
	return(result);
}

getcore() {
	register size_t *p;
	size_t bytes;
	register n,base;

	/*
	 * xglobs[] should be located in front of mglobs[], see upd_reloc()
	 */

	p = oursize; n = 0;
	n =+ (bytes.n_lines = p->n_lines * (sizeof *line));
	n =+ (bytes.n_llab = p->n_llab * (sizeof *locs));
	n =+ (bytes.n_glab = p->n_glab * (sizeof *xglobs));
	n =+ (bytes.n_mlab = p->n_mlab * (sizeof *mglobs));
	n =+ (bytes.n_mproc = p->n_mproc * (sizeof *mprocs));
	n =+ (bytes.n_xproc = p->n_xproc * (sizeof *xprocs));
	n =+ (bytes.n_proc = p->n_proc * (sizeof *proctab));
	n =+ (bytes.n_txtrel = p->n_txtrel * (sizeof *textreloc));
	n =+ (bytes.n_datrel = p->n_datrel * (sizeof *datareloc));
	base = askmore(n);
	line = lnp_cast base; base =+ bytes.n_lines;
	locs = lbp_cast base; base =+ bytes.n_llab;
	xglobs = gbp_cast base; base =+ bytes.n_glab;
	mglobs = gbp_cast base; base =+ bytes.n_mlab;
	mprocs = prp_cast base; base =+ bytes.n_mproc;
	xprocs = prp_cast base; base =+ bytes.n_xproc;
	proctab = ptp_cast base; base =+ bytes.n_proc;
	nxtextreloc = textreloc = rlp_cast base; base =+ bytes.n_txtrel;
	nxdatareloc = datareloc = rlp_cast base; base =+ bytes.n_datrel;
}

getsizes(str) char *str; {

	/*
	 * accepts -ss (small), -sm (medium), -sl (large)
	 * Should also accept: -s#,#,#,#,#,#,#,#
	 * When this is implemented compute prime numbers for
	 * hash table sizes.
	 */

	switch(*str) {
		default:error("bad size option %s",str);
	case 's':	oursize = &sizes[0]; break;
	case 'm':	oursize = &sizes[1]; break;
	case 'l':	oursize = &sizes[2]; break;
	}
}

char oflag;

argument(arg) char *arg; {
	register w,fd;
	
	/*
	 * This routine decides what to do with each argument.
	 * It recognises flags, obligatory modules, and
	 * optional modules.
	 * Furthermore, it knows a library when it sees it and
	 * call archive() to split it apart.
	 */

	if (oflag) {
		eout = arg;
		oflag=0;
		return;
	}
	if(*arg == '-') {
		flags(arg);
		return;
	}
	curfile = arg;	/* for error messages etc. */
	timing(-2);
	if ((fd = open(arg,0)) < 0) {
		error("can't open %s",arg);
		return;
	}
	finit(&ifile,fd);
	inpoff = 2;
	if ((w = xgetw(&ifile)) == CCMAGIC)
		module();
	else if (w == ARCCMAGIC)
		arentry();
	else if (w == ARMAG) {
		archmode = TRUE;
		archive();
		archmode = FALSE;
	} else
		error("%s: bad format",arg);
	if (close(ifile.fd) < 0)
		;
}

char *libname(str) char *str; {
	register char *p,*s1,*s2;
	char statbuf[36];

	/*
	 * If str is xxxx, this function returns (/usr)/lib/em1_xxxx.a
	 */

/*	p = "/usr/lib/em1_xxxxxxxxxx";*/
	p = "/user3/pas/lib/em1_xxxxxxxxxx";
/*	s1 = p+13;*/
	s1 = p+19;
	s2 = str;
	while(*s1++ = *s2++);
	s1--;
	s2=".a";
	while(*s1++ = *s2++);
/*	if (stat(p+4,statbuf)>0)*/
/*		p =+ 4;*/
	return(p);
}


/*
** process flag arguments
*/
flags(arg)
	char	*arg;
{
	register char	*argp;
	register on;

	argp = arg;
	while (*++argp)
	{
		switch(*argp)
		{
			case 'l':	argument(libname(argp+1)); return;
			case 'd':	silent=0;break;
			case 'p':	++procflag;break;
			case 'o':	++oflag; break;
			case '-':
			case '+':
				on = (*argp == '+');
				while (*++argp) switch(*argp) {
				case 't': if (on) intflags =| 01;
					  else intflags =& ~01;
					  break;
				case 'p': if (on) intflags =| 02;
					  else intflags =& ~02;
					  break;
				case 'f': if (on) intflags =| 04;
					  else intflags =& ~04;
					  break;
				case 'c': if (on) intflags =| 010;
					  else intflags =& ~010;
				case 'e': if (on) intflags =| 040;
					  else intflags =& ~040;
					  break;
				default:
				  error("bad interpreter option %s",argp);
				}
				--argp;
				break;
			default:
				error("bad flag %s",argp);
					break;
		}
	}
}

module() {

	/*
	 * Process one module.
	 * File is already open, various headers have been processed,
	 * what is left is pure compact EM1-code and is processed
	 * one procedure at a time.
	 *
	 * NOTE: The numbers of the passes, 1 3 4 and 5, are a remainder
	 *       of ancient times.
	 */

	init_module();
	do {
		initproc(); timing(0);
		read_compact(); timing(1); dump(1);
		pass_3(); timing(3); dump(3);
		pass_4(); timing(4); dump(4);
		pass_5(); timing(5); dump(5);
		endproc(); timing(6);
	} while (!eof_seen);
	end_module(); timing(-100);
}

archive() {
	register i,w;
	register char *p;

	/*
	 * Read a library.
	 * The format of the libary used is that of a UNIX-archive.
	 * For details see man 5 archive.
	 *
	 * NOTE: If it was allowed for an archive to contain
	 *       obligatory modules as well as optionals,
	 *	 it would not be possible to speed up things a bit
	 *	 by stopping when all references are resolved.
	 *	 This is the only reason.
	 */

	timing(1000);
	for(;;) {
		if (unresolved == 0) {	/* no use for this library anymore */
			timing(2000);
			return;
		}
		p = chp_cast &archhdr;
		if ((i = getc(&ifile)) < 0) {
			timing(3000);
			return;
		}
		*p++ = i;
		for (i=1;i< sizeof archhdr; i++)
			*p++ = readbyte();
		inpoff = 0;	libeof = archhdr.ar_size;
		/*
		 * UNIX archiveheader is read now, now process the contents
		 * of it. Note that recursive archives are not implemented.
		 *
		 * The variable libeof is used by readbyte() to check
		 * whether or not we try to pass the library-boundary.
		 */
		w = readword();
		if (w == ARCCMAGIC)
			arentry();
/*		else if (w == CCMAGIC)
			module();			*/
		else
			error("bad archive entry",0);
		skipentry();
		libeof = 0;
	}	/* up to the next entry */
}

int needed() {
	register glob_t *g;
	register proc_t *p;
	register i;
	int nglos,nprocs,result;
	char b[IDLENGTH+1];

	result= 0; b[IDLENGTH]= 0;
	nglos = readword();
	nprocs= readword();
	while(nglos--) {
		for(i=0;i<IDLENGTH;i++)
			b[i] = readbyte();
		if (g = xglolookup(b,SEARCHING))
			if ((g->g_status&(IMP|EXP)) == IMP)
				result++;
	}
	while(nprocs--) {
		for(i=0;i<IDLENGTH;i++)
			b[i] = readbyte();
		p = searchproc(b,xprocs,oursize->n_xproc);
		if (p->p_name[0])
			if ((p->p_status & (IMP|EXP)) == IMP)
				result++;
	}
	return(result);
}

arentry() {

	/*
	 * arentry() processes an optional module. Format is as follows:
	 *
	 *	MAGIC WORD		already processed
	 *	number of globals exported by this module
	 *	number of procedures exported by this module
	 *	list of global names.
	 *	list of procedure names.
	 *	GUARD WORD		for last check
	 */

	if (!needed())
		return;
	if (readword()!=ARGUARD)
		fatal("no guard in archive-entry");
	/*
	 * Header of entry is consumed
	 * furthermore this module contains interesting stuff,
	 * so let's assemble it now.
	 */

	module();
}

skipentry() {
	register b;

	/*
	 * for some reason the rest of this library entry needs to be
	 * skipped. Do that now.
	 */
	while(inpoff<libeof)
		b = readbyte();
	if(odd(libeof))			/* archive entries are evensized */
		if (getc(&ifile) < 0)	/* except maybe the last one */
			;
}

init_vars() {

	/*
	 * A small collection of variables is initialized.
	 * This occurs only for those that couldn't be initialized
	 * at compile-time.
	 */

	cutoff  = 256 - mnemon[op_cal&0377].m_nminis&0377;
	calminis= mnemon[op_cal&0377].m_nminis&0377;
	textreloc->r_off = -1;
	datareloc->r_off = -1;
	setmode(DATA_BSS);
	extbss(ABSSIZE);
	setmode(DATA_NUL);
}

init_files() {

	/*
	 * The temporary files on which text and data are kept
	 * during assembly are set up here.
	 *
	 * The function tmpfil() returns a file-descriptor
	 * of a file that is valid for reading and writing.
	 * It has the nice property of generating truly unique names.
	 */

	finit(&tfile,tmpfil());
	finit(&dfile,tmpfil());
}

initproc() {

	/*
	 * Called at the start of assembly of every procedure.
	 */

	zero(chp_cast locs,oursize->n_llab * sizeof *locs);
	nlocs = 0;
	lastcase    = 0;
	lastextcon = 0;
}

endproc() {

	/*
	 * Update linenumber for error messages.
	 */

	file_line =+ (last_line - line) + 1;
}

init_module() {

	/*
	 * Called at the start of every module.
	 */

	file_line = 0;
	eof_seen = 0;
	holbase  = 0;
}

char *
glostring(g) glob_t *g; {
	static char gbuf[7];
	register char *p;
	register num;

	if ((g->g_name[0]&0377)!=255)
		return(g->g_name);
	else {
		num = ((g->g_name[1]&0177)<<8)| (g->g_name[2]&0377);
		p= &gbuf[8];
		*--p=0;
		do { *--p = num%10 + '0';
		     num =/ 10;
		} while (num);
		*--p= '.';
		return(p);
	}
}

end_module() {

	/*
	 * Finish a module.
	 * Work to be done is mainly forgetting of local names,
	 * and remembering of those that will live during assembly.
	 */

	setmode(DATA_NUL);
	enmd_pro();
	enmd_glo();
}

enmd_pro() {
	register proc_t *p,*limit;

	/*
	 * Check that all local procedures have been defined,
	 * and forget them immediately thereafter.
	 */

	limit = &mprocs[oursize->n_mproc];
	for (p=mprocs; p<limit; p++) {
		if (p->p_name[0] == 0)
			continue;
		if ((p->p_status&DEF)==0)
			error("undefined local procedure %s",p->p_name);
	}
	zero(chp_cast mprocs,(limit-mprocs)* sizeof *mprocs);
}

enmd_glo() {
	register glob_t *mg,*xg,*limit;

	/*
	 * Tougher then enmd_pro().
	 * Check all the symbols used in this module that are
	 * not to be forgotten immediately.
	 * A difficulty arises here:
	 *     	In the tables textreloc[] and datareloc[]
	 *	pointers are used to identify the symbols concerned.
	 *	These pointers point into mglobs[].
	 *	Since at the end of assembly only the value of xglobs[]
	 *	is defined, these pointers have to be changed.
	 *	upd_reloc() takes care of this.
	 */

	limit = &mglobs[oursize->n_mlab];
	for ( mg = mglobs; mg < limit; mg++) {
		if (mg->g_name[0] == 0)
			continue;
		if ((mg->g_status&(FWD|DEF))==FWD)
			error("undefined local symbol %s",glostring(mg));
		if ((mg->g_status&(EXP|IMP))==0)
			continue;
		if ((mg->g_status&(EXP|DEF)) == DEF)
			continue;
		xg = xglolookup(mg->g_name,ENTERING);
		switch(xg->g_status&(EXP|IMP)) {
		case 0:		/* new symbol */
			if((mg->g_status&EXP)==0)
				++unresolved;
			break;
		case IMP:	/* already used but not defined */
			if(mg->g_status&EXP) {
				--unresolved;
			}
			break;
		case EXP:	/* only defined, not imported yet */
		case EXP|IMP:	/* this symbol has seen everything */
			if(mg->g_status&EXP)
				error("Multiple defined: %s",glostring(mg));
		}
		if ((mg->g_status&(EXP|DEF))==EXP)
			error("Exported and not defined: %s",glostring(mg));
		xg->g_status =| mg->g_status;
		if (mg->g_status&DEF)
			xg->g_val = mg->g_val;
		mg->g_val = int_cast xg;		/* used by upd_reloc */
	} /* up to the next symbol */
	upd_reloc();
	zero(chp_cast mglobs,(limit-mglobs)*sizeof *mglobs);
}

upd_reloc() {
	register relc_t *p;
	register glob_t *gbp;

	/*
	 * Change reloc-tables such that for every pointer into mglobs
	 * either the corresponding pointer into xglobs or its value
	 * are substituted.
	 *
	 * Use is made of the known order of mglobs and xglobs
	 * see also getcore()
	 */

	for(p=nxtextreloc-1;p>=textreloc && (!(p->r_typ&MNS)) &&
			     (gbp=p->r_val.rel_gp) >= mglobs ; p--)
		if((gbp->g_status&(DEF|EXP))==DEF) {
			p->r_typ =| MNS;
			p->r_val.rel_i = gbp->g_val;
		} else
			p->r_val.rel_gp = gbp_cast gbp->g_val;

	for(p=nxdatareloc-1;p>=datareloc && (p->r_typ!=RELGLO ||
			     (gbp=p->r_val.rel_gp)>=mglobs) ; p--)
		if (p->r_typ == RELGLO)
		if((gbp->g_status&(DEF|EXP))==DEF) {
			p->r_typ = RELCON;
			p->r_val.rel_i = gbp->g_val;
		} else
			p->r_val.rel_gp = gbp_cast gbp->g_val;
}

finish_up()
{
	/*
	 * Almost done. Check for unresolved references,
	 * make the e.out file and stop.
	 */

	check_def();
	copyout();
}

check_def() {
	register proc_t *p;
	register glob_t *g;
	register count;

	/*
	 * Check for unresolved references.
	 * NOTE: The occurring of unresolved references is not fatal,
	 *       although the use of the e.out file after this
	 *	 occurring must be strongly discouraged.
	 *	 Every use of the symbols concerned is undefined.
	 */

	if (unresolved) {
		printf("Unresolved references:\n  Procedures:\n");
		count = oursize->n_xproc;
		for (p = xprocs; count--; p++)
			if (p->p_name[0] && (p->p_status&DEF)==0)
				printf("    %s\n",p->p_name);
		printf("  Data:\n");
		count = oursize->n_glab;
		for (g = xglobs; count--; g++)
			if (g->g_name[0] && (g->g_status&DEF)==0)
				printf("    %s\n",glostring(g));
	}
}

ertrap() { /* trap routine to drain input in case of compile errors */

	if (ifile.fd == 0)
		while (getc(&ifile) >= 0)
			;
	exit(1);
}
