/	SUBTITLE	b-gcoffst.s	compute offsets for relocation
/	Written by Steven Hardy on 21 April 1976
/	This function is called with r0 containing a pointer to a record in the heap.
/	If the record is in use nothing is done.
/	If not the amount of free space so far (held in r3) is stored in the first
/	field of the record and the amount of free space so far increased by the
/	the size of the record
/	If this is the first free record (i.e r3=0) the variable bgclo is set
/	to point to this record
/
sgcoffst:
	bit	r4,okey(r0)		/ is record marked?
	bne	2f			/ br if so
	cmp	okey(r0),$kdevice-1	/ is record a device?
	bne	1f			/ br if not
	mov	r0,-(r5)		/ save r0
	mov	(r0),r0			/ get channel number to r0
	sys	close			/ close the file
	mov	(r5)+,r0		/ restore r0
1:
	mov	r3,(r0)			/ store free space so far
	bne	1f			/ br if this was not the first
	mov	r0,bgclo		/ set first free record pointer
1:
	add	r1,r3			/ r1 is end of current record
	sub	r0,r3
2:
	rts	pc
