/	SUBTITLE	c-interpret.s	user function interpreter
/	Written by Steven Hardy on 28 April 1976
/
	ksfunction
finterpret:
	br	sinterpret
	false;	false
	mov	(sp)+,r0		/ restore function to r0
	mov	(r0),r1			/ get number of locals to r1
	beq	2f			/ br if none
	add	$6,r0			/ move r0 past fnprops etc
	add	r1,r0			/ move r0 past locals
	add	r1,r0			/ r1 is number of locals add twice to get bytes
1:
	mov	(sp)+,*-(r0)		/ restore a local
	sob	r1,1b			/ loop back if more to go
2:
	mov	(sp)+,pvar1		/ restore program counter variable
	rts	pc
sinterpret:
	mov	pvar1,-(sp)		/ to store user program counter
	mov	(r5)+,r0		/ pop function to r0
	mov	(r0),r1			/ number of locals to r1
	bne	1f			/ br to slow entry code if has locals
	mov	r0,-(sp)		/ save the function
	mov	r0,r3			/ r3 is user pc during execution
	add	$6,r3			/ advance r3 past fnprops etc
	jmp	*(r3)+			/ dispatch on next op type
1:
	mov	r0,r3			/ r3 will be user pc during execution
	add	$6,r3			/ move r3 past fnprops etc
1:
	mov	*(r3)+,-(sp)		/ save next local
	sob	r1,1b			/ loop back if more to save
	mov	r0,-(sp)		/ save user function itself on stack
	mov	(r3)+,r1		/ number of input variables to r1
	beq	2f			/ br if none
	mov	r3,r2			/ make temporary use of r2
	sub	$2,r2			/ we have moved r3 on 2 so must move r2 back
1:
	mov	(r5)+,*-(r2)		/ bind next input variable
	sob	r1,1b			/ loop back if more to bind
2:
	jmp	*(r3)+			/ dispatch on next op type
	.if	draft
	cvpush
	.endif
vpush:
	mov	*(r3)+,-(r5)		/ push value of stored word
	cmp	r5,br5lo		/ stack overflow?
	blos	vweird			/ br if so
	jmp	*(r3)+			/ dispatch to next op
	.if	draft
	cvpop
	.endif
vpop:
	mov	(r5)+,*(r3)+		/ pop value of next word
	jmp	*(r3)+			/ dispatch to next op
	.if	draft
	cvpushq
	.endif
vpushq:
	mov	(r3)+,-(r5)		/ push next object
	cmp	r5,br5lo		/ user stack overflow?
	blos	vweird			/ br if so
	jmp	*(r3)+			/ dispatch to next op
	.if	draft
	cvifso
	.endif
vifso:
	mov	(r3)+,r0		/ get offset to r0
	cmp	(r5)+,$false		/ is there a false on the stack?
	beq	1f			/ br if so
	add	r0,r3			/ if not alter r3
1:
	jmp	*(r3)+			/ dispatch to next op
	.if	draft
	cvifnot
	.endif
vifnot:
	mov	(r3)+,r0		/ get offset to r0
	cmp	(r5)+,$false		/ is there a false on the stack?
	bne	1f			/ br if not
	add	r0,r3			/ alter r3
1:
	jmp	*(r3)+			/ dispatch on next op
	.if	draft
	cvpifso
	.endif
vpifso:
	mov	(r3)+,r0		/ get offset to r0
	cmp	(r5)+,$false		/ is there a false on the stack?
	beq	1f			/ br if so
	tst	-(r5)			/ put the objectback on the stack
	add	r0,r3			/ alter r3
1:
	jmp	*(r3)+			/ dispatch to nextop
	.if	draft
	cvpifnt
	.endif
vpifnt:
	mov	(r3)+,r0		/ get offset to r0
	cmp	(r5)+,$false		/ is there a false on the stack?
	bne	1f			/ br if not
	tst	-(r5)			/ replace object on stack
	add	r0,r3			/ alter r3
1:
	jmp	*(r3)+			/ dispatch to next op
	.if	draft
	cvgoby
	.endif
vgoby:
	add	(r3)+,r3		/ alter r3
	tst	btime			/ interrupt?
	bne	vweird			/ br if so
	jmp	*(r3)+			/ dispatch on next o@
vweird:
	sub	(sp),r3			/ turn userpc to offset
	mov	r3,pvar1		/ and store
	jsr	pc,scheck		/ de a check
	mov	pvar1,r3		/ reset userpc
	add	(sp),r3			/ as absolute
	jmp	*(r3)+			/ dispatch to next op
	.if	draft
	cvcall
	.endif
vcall:
	mov	*(r3)+,r0		/ get value of next word to r0
	mov	r0,-(r5)		/ put it on stack
	sub	(sp),r3			/ convert userpc to offset
	mov	r3,pvar1		/ and store
	jsr	pc,sapply		/ apply function
	mov	pvar1,r3		/ restore user pc
	add	(sp),r3			/ as absolute
	jmp	*(r3)+
	.if	draft
	cvucall
	.endif
vucall:
	mov	*(r3)+,-(r5)		/ push value of next word
	sub	(sp),r3			/ convert userpc to offset
	mov	r3,pvar1		/ and save
	jsr	pc,uapply		/ apply its updater
	mov	pvar1,r3		/ restore user pc
	add	(sp),r3			/ as absolute
	jmp	*(r3)+			/ dispatch to next op
	.if	draft
	cvcallq
	.endif
vcallq:
	mov	(r3)+,-(r5)		/ push next object
	sub	(sp),r3			/ convert userpc to offset
	mov	r3,pvar1		/ and save
	jsr	pc,sapply		/ apply it
	mov	pvar1,r3		/ restore user pc
	add	(sp),r3			/ as absolute
	jmp	*(r3)+
	.if	draft
	cvcalls
	.endif
vcalls:
	mov	(r3)+,r0		/ function to r0
	sub	(sp),r3			/ compute userpc offset
	mov	r3,pvar1		/ store
	jsr	pc,(r0)			/ apply function
	mov	pvar1,r3		/ get offset
	add	(sp),r3			/ convert to absolute
	jmp	*(r3)+			/ transfer to next operation
	.if	draft
	cvreturn
	.endif
vreturn:
	mov	(r3)+,r0		/ get number of output locals to r0
	jeq	finterpret+6		/ jump to exit code if none
	mov	(sp),r1			/ get function to r1
	add	$6,r1			/ move r1 past fnprops etc
1:
	mov	*(r1)+,-(r5)		/ push an output local's value
	sob	r0,1b			/ loop back if more to go
	jbr	finterpret+6		/ br to exit code
