/	SUBTITLE	c-popmess.s	popmess
/	Written by Steven Hardy on 22nd January 1977
/	
/
/	This function is used to send 'messages'
/	from a POP11 program to the underlying systems
/	- namely UNIX and POP11 itself.
/	Messages for UNIX are lists, those
/	for POP11 are integers.
/	Lists for UNIX are modelled on SYS 
/	calls as described in the UNIX programmers
/	manual. Where an initial assignemnts to r0
/	is required it will be assumed to be the last element
/	of the list.
/	Where a result is indicated in r0 this will form the
/	basis of popmess's result
/	Integral arguments specify which element of a
/	'secret parameter' strip the user wants as a 
/	result. (popmess has an appropriate updater.)
	ksfunction
fpopmess:
	br	spopmess
	wpopmess; upopmess; rts pc
error=.
	add	$1200.,r0
	asl	r0
	inc	r0
	mov	r0,-(r5)
	jsr	pc,serror
spopmess:
	bit	r4,(r5)			/ is argument integral?
	beq	1f			/ br if not
	mov	$psecret,-(r5)		/push secret strip
	jsr	pc,ssubscr		/ subscr()
	rts	pc
1:
	jsr	pc,spmsetup		/ setup()
	cmp	r1,$47.			/ allowable argument?
	bgt	1f
	asl	r1
	jmp	*pmtype(r1)
1:
	clr	r0
	br	error
/ fork
pmfork:
	jsr	pc,sgarbage		/ do a garbage collection
	sys	fork			/ issue sys call
	br	1f			/ child brancescape
	br	pmresult		/ parent gets identity of child as result
1:
	bcs	error			/ check for fork failure
	mov	$false,(r5)		/ child gets result false
	mov	$fkill,winterrupt	/ set interrupt function to be popmess([%Exit%])
	rts	pc
/ wait
pmwait:
	sys	wait			/ issue wait
	bcc	1f			/ br if successful
	cmp	r0,$EINTR		/ interrupted?
	bne	error			/ error if not
	sys	signal; 2; ssgint	/ reset trap
	clr	bsgint			/ clear interrupt flag
	br	pmwait			/ loop back
1:
	asl	r0			/ identity to POP11 format
	inc	r0
	mov	r0,pchild		/ store
	mov	r1,r0			/ status to r0
pmresult:
	asl	r0			/ convert status
	inc	r0			/ to be result
	mov	r0,(r5)			/ replace arg by result
	rts	pc			/ done
/ close
pmclose:
	sys	close			/ close file
	bcs	error			/ br on error
	bit	r4,r2			/ was arg a device?
	bne	1f			/ br if not
	mov	$-1,(r2)		/ mark device as closed
1:
	tst	(r5)+			/ remove arg from stack
	rts	pc			/ done
/ pipe
pmpipe:
	jsr	pc,spmfile		/ open channels
	bcs	error
	mov	r0,(r5)			/ save read channel
	mov	r1,-(r5)		/ push write channel
	mov	 $cpipe,-(r5)		/ push 'pipe'
	jsr	pc,sdevice		/ make device
	jsr	pc,sswap		/ get read channel
	mov	$cpipe,-(r5)		/ push 'pipe'
	jbr	sdevice			/ chain (device)
/ write
pmwrite:
	jsr	pc,spmobey		/ issue command
	mov	bhphi,r1
	cmp	r0,4(r1)		/ all written?
	bne	error
	tst	(r5)+			/ remove arg from stack
	rts	pc
/ non file openers
/ those non file openers that don't return a result
pmno:
	jsr	pc,spmobey
	bcs	error
	tst	(r5)+
	rts	pc
/ those file openers that return a result
pmyes:
	jsr	pc,spmobey
	bcs	error
	br	pmresult		/ r0 is result
/ file openers
pmopen:
	jsr	pc,spmfile
	bcs	error
	mov	r0,(r5)
	mov	r2,-(r5)
	jbr	sdevice
pmbyte:
	jsr	pc,spmobey
	bcs	error
	bic	$177600,r0		/ clear all but low byte
	br	pmresult
/
	.if	bigdata
	.data
	.endif
pmtype:	error				/ (0) indir
	pmno				/ (1) exit
	pmfork				/ (2) fork
	pmyes				/ (3) read
	pmwrite				/ (4) write
	pmopen				/ (5) open
	pmclose				/ (6) close
	pmwait				/ (7) wait
	pmopen				/ (8) creat
	pmno				/ (9) link
	pmno				/ (10) unlink
	pmno				/ (11) exec
	pmno				/ (12) chdir
	error				/ (13) time
	pmno				/ (14) mknod
	pmno				/ (15) chmod
	pmno				/ (16) chdir
	error				/ (17) break
	pmno				/ (18) stat
	pmno				/ (19) seek
	pmyes				/ (20) getpid
	pmno				/ (21) mount
	pmno				/ (22) umount
	pmno				/ (23) setuid
	pmbyte				/ (24) getuid
	error				/ (25) stime
	error				/ (26) ptrace
	error				/ (27)
	pmno				/ (28) fstat
	error				/ (29)
	error				/ (30)
	pmno				/ (31) stty
	pmno				/ (32) gtty
	error				/ (33)
	pmno				/ (34) nice
	pmno				/ (35) sleep
	pmno				/ (36) sync
	pmno				/ (37) kill
	pmyes				/ (38) csw
	error				/ (39)
	error				/ (40)
	pmopen				/ (41) dup
	pmpipe				/ (42) pipe
	error				/ (42)
	pmno				/ (43) times
	error				/ (44) profil
	error				/ (45)
	pmno				/ (46) setgid
	pmbyte				/ (47) getgid
	.if	bigdata
	.text
	.endif
/
	ksfunction
upopmess:
	br	1f
	wpopmess; false; rts pc
1:
	mov	$psecret,-(r5)
	jsr	pc,usubscr
	rts	pc
