/*
 *	lpr -- spool printout for online printer.
 *
 *		should be setuid to root
 */

#include	<local-system>
#include	<types.h>
#include	<stat.h>
struct stat statbuf;
#include	<passwd.h>
struct pwent pe;
#include	<signal.h>
#include	<sgtty.h>
#include	<printers.h>
struct printer *ptype;
#include	<fcntl.h>
#include	<stdio.h>

#define	R	04	/* read permission - access call */
#define W	02	/* write permission - access call */

#define	BIG	32767

char	lpddir[] =	LPDDIR;
char	tfnx[] =	"tfaXXXXXX";
char	cfnx[] =	"c0000XXXXXX";
int	cname;		/* current copy temp name (0..999) */
#define	CPOSN	1
#define	CUNIQ	2
char	dfnx[] =	"0/dfxXXXXXXXXX";
#define	DPOSN	0
#define	DQUICK	4
char	lknx[] =	"lock0";
#define	LPOSN	4
char	tfn[sizeof lpddir + sizeof tfnx];
char	cfn[sizeof lpddir + sizeof cfnx];
char	dfn[sizeof lpddir + sizeof dfnx];
char	lkn[sizeof lpddir + sizeof lknx];

int	tff;		/* file desc. of tfn file */
int	pageno;		/* total size of job (pages) */
char	*arg;		/* current file name */

extern char *strcpy();
extern char *strcat();


main(ac, av)
char *av[];
{
	register f;
	register short nact;
	char rflg, xban, push, yflg, quick, nocopy;
	char *xmsg, *iden, *ncopies;
	char namebuf[SSIZ];
	int rubout();
	char *mytty();
	char autoprint = 0;

	if (signal(SIGINT, SIG_IGN) == 0)
		signal(SIGINT, rubout);
	signal(SIGQUIT, SIG_IGN);
	rflg = xban = push = yflg = quick = nocopy = nact = 0;
	xmsg = iden = ncopies = 0;
	f = getuid();
	pe.pw_limits.l_uid = f;
	if (getpwlog(&pe, namebuf, sizeof namebuf) < 0)
	{
		fprintf(stderr, "Who are you?\n");
		exit(1);
	}
	while (ac > 1 && (arg = av[1])[0] == '-')
	{
		switch (*++arg)
		{
		case 'c':
			/*
			 * don't take a copy - as this also avoids
			 * the pagelimit check, multiple formfeed
			 * absorption, and optimised overstriking,
			 * its usage should be restricted.
			 * There is also a security problem, in that
			 * the file tested now may not be the same one
			 * when lpd comes around....
			 */
			if (pe.pw_pages == 0)
				nocopy++;
			break;

		case 'e':
			if (f == 0)	/* higher priority */
				quick = 1;
			break;

		case 'i':
			iden = arg + 1;	/* rename banner */
			break;

		case 'm':
			xmsg = arg + 1;	/* lpd message when finished */
			break;

		case 'n':
			ncopies = arg + 1;	/* number of copies */
			break;

		case 'p':
			if (f == 0)	/* push out of printer */
				push++;
			break;

		case 'r':
			rflg++;		/* remove */
			break;

		case 's':
			quick = -1;	/* lower priority */
			break;

		case 'x':
			xban++;		/* no banner */
			break;

		case 'y':
			yflg++;		/* suppress page skips */
			break;

		case '0':
		case '1':
		case '2':
		case '3':
		case '4':		/* printer number */
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			for (ptype = printer; ptype < &printer[NPRINTERS]; ptype++)
				if (ptype->ident == *arg)
					break;
			if (ptype == &printer[NPRINTERS])
			{
				fprintf(stderr, "Illegal printer number\n");
				exit(1);
			}
			lknx[LPOSN] = dfnx[DPOSN] = cfnx[CPOSN] = *arg;
			break;

		default:
			fprintf(stderr, "Usage: lpr [-flags] [-0..9] [file] ...\n");
			fprintf(stderr, "  flags: c, e, ibanner, mmessage, ncopies, p, r, s, x, y\n");
			exit(1);
		}
		ac--;
		av++;
	}

	if (ptype == NULL)
	{
		/*
		 * determine the shortest print queue
		 */
		int		min = BIG;
		int		lockfd;
		struct lpdlock	lpdlck;
		struct printer	*pp;

		autoprint++;
		for (pp = printer; pp < &printer[NPRINTERS]; pp++)
			if (pp->autoselect)
			{
				lknx[LPOSN] = pp->ident;
				strcat(strcat(strcpy(lkn, lpddir), "/"), lknx);
				lockfd = -1;
				if ((lockfd = open(lkn, O_READ)) != -1 &&
				    read(lockfd, &lpdlck, sizeof lpdlck) == sizeof lpdlck &&
				    lpdlck.lpd_pages < min)
				{
					min = lpdlck.lpd_pages;
					ptype = pp;
				}
				if (lockfd >= 0) close(lockfd);
			}
		if (min == BIG)
		{
			fprintf(stderr, "No default printer operating\n");
			exit(1);
		}
		lknx[LPOSN] = dfnx[DPOSN] = cfnx[CPOSN] = ptype->ident;
	}
	/*
	 * check if login name is a student number - if so,
	 * use the person's surname
	 */
	if ((f = pe.pw_strings[LNAME][0]) >= '0' && f <= '9')
		pe.pw_strings[LNAME] = pe.pw_strings[LASTNAME];

	mktemp(tfnx);
	mktemp(cfnx);
	dfnx[DQUICK] -= quick;
	strcat(strcat(strcpy(tfn, lpddir), "/"), tfnx);
	strcat(strcat(strcpy(cfn, lpddir), "/"), cfnx);
	strcat(strcat(strcpy(dfn, lpddir), "/"), dfnx);
	strcat(strcat(strcpy(lkn, lpddir), "/"), lknx);
	tff = open(tfn, O_WRITE | O_CREAT | O_TRUNC | O_FREE, 0600);
	if (tff == -1)
	{
		perror(tfn);
		exit(1);
	}
	card(LP_UID, &pe.pw_limits.l_uid, sizeof pe.pw_limits.l_uid);
	if (xban == 0)
	{
		if (iden == 0)
			iden = pe.pw_strings[LNAME];
		card(LP_BANNER, iden, strlen(iden));
	}
	if (push)
		card(LP_PUSH, 0, 0);
	if (ncopies)
		card(LP_COPIES, ncopies, strlen(ncopies));
	if (yflg)
		card(LP_NOSKIP, 0, 0);
	arg = 0;
	if (ac == 1 && copy(0) == 0)	/* probably the end of a pipe */
		nact++;
	while (--ac)
	{
		arg = *++av;
		if (access(arg, R))
		{
			perror(arg);
			continue;
		}
		f = open(arg, O_READ);
		if (f == -1)
		{
			perror(arg);
			continue;
		}
		fstat(f, &statbuf);
		if ((statbuf.st_mode & S_IFMT) == S_IFDIR)
		{
			fprintf(stderr, "%s: is a directory\n", arg);
			close(f);
			continue;
		}
		if (nocopy)
		{
			close(f);
			if (arg[0] != '/')
			{
				fprintf(stderr, "%s: must be full pathname from /\n", arg);
				continue;
			}
			card(LP_FILE, arg, f = strlen(arg));
			if (rflg)
				if (remvp() == 0)
					card(LP_RM_C, arg, f);
				else
					fprintf(stderr, "%s: can't remove\n", arg);
			nact++;
			continue;
		}
		if (copy(f))
		{
			close(f);
			continue;
		}
		close(f);
		nact++;
		if (rflg)
			if (remvp() == 0)	/* check for remove permission */
				unlink(arg);
			else
				fprintf(stderr, "%s: can't remove\n", arg);
	}

	if (xmsg)
	{
		if (*xmsg)
			card(LP_MESG, xmsg, strlen(xmsg));
		xmsg = mytty();
		card(LP_TTY, xmsg, strlen(xmsg));
	}
	if (xban == 0 && ptype->baudrate == PARALLEL)
		pageno++;	/* allow for banner page */
	if (pageno)
		card(LP_PAGES, &pageno, 2);
	if (nact)
	{
		int		lockfd;
		struct lpdlock	lpdlck;

		nextname();
		if (link(tfn, dfn))
		{
			perror("lpr link");
			cfnzap();
			unlink(tfn);
			exit(1);
		}
		if ((lockfd = open(lkn, O_RDWR)) == -1 ||
		    read(lockfd, &lpdlck, sizeof lpdlck) != sizeof lpdlck)
			fprintf(stderr, "LPD not accessible - tell a guru\n");
		else
		{
			lpdlck.lpd_pages += pageno;
			if (lseek(lockfd, 0L, 0) == -1 ||
			    write(lockfd, &lpdlck, sizeof lpdlck) != sizeof lpdlck ||
			    kill(lpdlck.lpd_pid, SIGKICK) == -1)
				fprintf(stderr, "LPD not accessible - tell a guru\n");
			else if (autoprint)
				fprintf(stderr, "Printout directed to printer %c\n", ptype->ident);
		}
	}
	unlink(tfn);
	exit(0);
}

copy(ifd)
int ifd;
{
	register i, j;
	int ofd;

	if (cname == 999)
	{
		fprintf(stderr, "Can't create copy temp file\n");
		exit(1);
	}
	ofd = open(cfn, O_WRITE | O_CREAT | O_TRUNC | O_FREE, 0600);
	if (ofd == -1)
	{
		perror(cfn);
		return(1);
	}
	if (i = pcheck(ifd, ofd))
		unlink(cfn);
	else
	{
		card(LP_FILE, cfn, j = strlen(cfn));
		card(LP_RM, cfn, j);
	}
	cname++;
	cfn[CUNIQ + sizeof lpddir] = (char) cname / 100 + '0';
	cfn[CUNIQ + sizeof lpddir + 1] = (char) cname % 100 / 10 + '0';
	cfn[CUNIQ + sizeof lpddir + 2] = (char) cname % 10 + '0';
	close(ofd);
	return(i);
}

cfnzap()	/* routine to garotte all cfn files attached to this job */
{
	for (;;)
	{
		unlink(cfn);
		if(cname == 0)
			return;
		cname--;
		cfn[CUNIQ + sizeof lpddir] = (char) cname / 100 + '0';
		cfn[CUNIQ + sizeof lpddir + 1] = (char) cname % 100 / 10 + '0';
		cfn[CUNIQ + sizeof lpddir + 2] = (char) cname % 10 + '0';
	}
}

card(c, s, sz)
int c;
register char *s;
{
	register char *bp;
	register i;
	char buf[LPDMSZ];

	bp = buf;
	*bp++ = c;
	if (++sz > sizeof buf)	/* add one for the first char */
		sz = sizeof buf;
	for (i = 1; i < sz; i++)
		*bp++ = *s++;
	while (i++ < sizeof buf)
		*bp++ = 0;
	write(tff, buf, sizeof buf);
}

/*
 * We have been asked to remove a file.
 * As this program is setuid to root, we must be cautious.....
 */
remvp()
{
	int	wflag;
	register char *p, *q, *r;
	char c;

	/*
	 * statbuf has already been set up for current file
	 */
	if ((statbuf.st_mode & S_IFMT) != S_IFREG)
		return(1);
	wflag = pe.pw_limits.l_uid != statbuf.st_uid;	/* set if don't own file */
	p = arg;
	r = p+1;
	if (*p == 0)	/* null argument */
		return(1);
	/*
	 * Set up the default parent directory names
	 */
	if (*p == '/')
		q = "/";
	else
		q = "";
	while (*r)
	{
		if (*r++ == '/')
		{
			while (*r == '/')
				r++;
			if (*r)
				p = r;
			q = arg;
		}
	}
	if (q == arg)
		p--;
	c = *p;		/* note that "r = (char *)*p;" does NOT work! */
	*p = 0;
	stat(q, &statbuf);
	if (pe.pw_limits.l_uid == statbuf.st_uid || wflag == 0 ||
	    pe.pw_limits.l_uid == 0)
		wflag = access(q, W);
	*p = c;
	return(wflag);
}

rubout()
{
	signal(SIGINT, SIG_IGN);
	unlink(tfn);
	cfnzap();
	unlink(dfn);
	exit(1);
}

/*
 * The following strings is in ascii collating order
 */
char tnchars[] = ",.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

nextname()
{
	register char *p, *q;
	register short pid;
	long	systime;
	extern long time();

	for (p = dfn; *p; p++);
	pid = getpid();
	q = p - 3;
	while (p != q)
	{
		*--p = tnchars[pid & 077];
		pid >>= 6;
	}
	systime = time(0L);
	q = p - 6;
	while (p != q)
	{
		*--p = tnchars[systime & 077];
		systime >>= 6;
	}
}

/*
 * Copy file to temporary, doing a quick page check
 */
pcheck(in, out)
int in, out;
{
	register char *cp;
	register n;
	short lines, pages;
	short plim;
	char buf[BUFSIZ];

	lines = 0;
	pages = 0;
	plim = pe.pw_pages * ptype->pagemult;
	n = read(in, buf, sizeof buf);
	if (n == 0)		/* empty file */
		return(0);
	if (n >= 2)
	{
		register short *sp;

		sp = (short *)&buf[0];
		switch(*sp)
		{
		case 0407:		/* executable */
		case 0410:		/* shared text */
		case 0177545:		/* archive */
		case 017437:		/* packed - pdp */
		case 017037:		/* packed - vax */
			fprintf(stderr, "%s: illegal file type\n",
				arg ? arg : "(stdin)");
			return(1);
		}
	}
	do
	{
		for (cp = buf; cp < &buf[n]; cp++)
			switch(*cp)
			{
			case '\n':
				lines++;
				if (lines < ptype->pagelength)
					continue;
			case '\f':
				lines = 0;
				pages++;
				if (plim > 0 && pages == plim)
				{
					fprintf(stderr, "Page limit exceeded - print cancelled\n");
					return(1);
				}
				continue;
			}
		write(out, buf, n);
		n = read(in, buf, sizeof buf);
	} while (n > 0);
	if (lines)
		pages++;
	pageno += pages;
	return(0);
}
