#include "draw.h"
writef(cp)
char *cp;
{

	FILE	*outfile;

	register unsigned i, j, k;
	register struct symbol *q;
	register union unit   *p;
	short basex, basey;

	if((outfile =fopen(cp, "w")) == NULL)
	{
		perror(cp);
		oldline();
		return;
	}


	CHANGED = 0;
	cleanout();
	q = symtab;
	for(i = 0;i < nsyms;i++,q++)
	{
		if(symtab[i].def & LIB) continue;
		readin(&symtab[i]);
		fprintf(outfile, "%.*s\n", NAMESIZ, q->name);
		for(p = q->list->mod.up;p != NULL;p = p->mod.up)
		{
			switch(p->mod.op)
			{
			case LINE:
				/* count how many segments so we can display in old dmode (x, y pair) */
				for(k = 0, j = 0; j < p->l.nsegs;k++, j++)
					if(p->l.ls[j].a.dmode == DELTAXY)
						j++;

				/* k is the number of pairs */
				fprintf(outfile, "\t$linec\t%o\t%d\n",
					 p->l.level, k);
				basex = p->l.x;
				basey = p->l.y;
				fprintf(outfile, "\t\t%d\t%d\n", basex, basey);
				for(k = 0;k < p->l.nsegs;k++)
				{
					switch(p->l.ls[k].a.dmode)
					{
					case DELTAX:
						basex += extend(p->l.ls[k].a.delta);
						break;
					case DELTAY:
						basey += extend(p->l.ls[k].a.delta);
						break;
					case DELTAXY:
						basey += extend(p->l.ls[k].a.delta);
						basex += p->l.ls[k+1].b.delta1;
						k++;
						break;
					case SDELTAXY:
						basey += sextend(p->l.ls[k].c.deltay1);
						basex += sextend(p->l.ls[k].c.deltax1);
						break;
					}
					fprintf(outfile, "\t\t%d\t%d\n", basex, basey);
				}
				break;
			case ARC:
				fprintf(outfile, "\t$arc\t%o\t%d\t%d\t%d\t%d\t%d\t%d\n",
					p->arc.level, p->arc.x, p->arc.y,
					p->arc.x1, p->arc.y1,
					p->arc.cx, p->arc.cy);
				break;

			case STRING:
				fprintf(outfile, "\t$str\t%o\t%d\t%d\t%d\t%d\t%d\n",
					p->str.level, p->str.cnt,
					p->str.sscale, p->str.x, p->str.y,
					p->str.srot);
				fprintf(outfile, "\t\t%s\n", p->str.sp);
				break;
			case CIRCLE:
				fprintf(outfile, "\t$circle\t%o\t%d\t%d\t%d\t%d\n",
					 p->cir.level, p->cir.x, p->cir.y, p->cir.rad);
				break;
			case MODULE:
				fprintf(outfile,"\t%.*s\t%o\t%d\t%d\t%d\t%d\n",
					NAMESIZ, symtab[p->mod.modnum].name, 0,
					p->mod.x, p->mod.y, p->mod.mscale, p->mod.mrot);
			}
		}
		fprintf(outfile, "\t$end\n");
	}

	deleteincore(1, q);
	if(ferror(outfile))

		warn("write failed\n");
	fclose(outfile);
}

/* read a file of specifications */
readf(p)
char *p;
{
	readf1(p, 0);
}

lib(cp)
char *cp;
{
	readf1(cp, LIB);
}

readf1(cp, flg)
char *cp;
{
	FILE *infile;
	register union unit *r;
	register struct symbol *q, *pp;
	register i, j, k;

	int inline = 1;
	int n;
	int orignsyms;
	unsigned cnt;

	char buf[80];
	char name[80];
	char str[80];

	short lev;
	short x, y;
	short basex, basey;
	short deltax, deltay;
	short cloop = 0;

	if((infile = fopen(cp, "r")) == NULL)
	{
		perror(cp);
		oldline();
		return;
	}
	orignsyms = nsyms;

	while(fgets(buf, 80, infile) != NULL)
	{
		inline++;
		if(sscanf(buf, "%s", name) != 1)
		{
			continue;
		}
		if((q = lookup(name)) != NULL)
		{
			if(q->def & DEF )
			{
				fprintf(stderr, "%.*s: already exists\n", NAMESIZ, name);
				oldline();
				goto bad;
			}
			q->def = DEF + flg;
		}
		else
		{

			q = &symtab[nsyms++];
			strncpy(q->name, name, NAMESIZ);
			q->def = DEF + flg;
			q->list = (union unit *) mmalloc(sizeof (struct smod));
			q->list->mod.up = NULL;
			q->size = 0;
		}
		for(;;)
		{
			inline++;
			if(fgets(buf, 80, infile) == NULL)
			{
				fprintf(stderr, "Unexpected EOF\n");
				oldline();
				goto bad1;
			}
			if(sscanf(buf, "%s", str) != 1)
				continue;
			if(strcmp(str, "$end") == 0)
				break;
			if(strcmp(str, "$linec") == 0)
			{
				r = (union unit *) mmalloc(sizeof (struct line));
				r->l.up = NULL;
				q->size++;
				if(sscanf(buf, "%s%ho%d",
					str, &lev, &cnt) != 3)
					goto bad1;
				r->l.op = LINE ;
				r->l.level = lev;
				r->l.ls = (union lineseg*) mmalloc(sizeof (union lineseg));
				if((fgets(buf, 80, infile) == NULL) ||
					(sscanf(buf, "%hd%hd", &r->l.x, &r->l.y) != 2))
					goto bad1;
				inline++;
				basex = r->l.x;
				basey = r->l.y;
				k = -1;
				for(j = 0;j < cnt;j++)
				{
					if((fgets(buf, 80, infile) == NULL) ||
						(sscanf(buf, "%hd%hd", &x, &y) != 2))
						goto bad1;
					inline++;
				loop:
					deltax = x - basex;
					deltay = y - basey;
					r->l.ls = (union lineseg *) mrealloc((char *)r->l.ls, sizeof(union lineseg) * (++k +1));
					if(deltax == 0)	/* deltay only */
					{
						r->l.ls[k].a.dmode = DELTAY;
						if(deltay < 0)
						{
							if(deltay < -8096)
							{
								r->l.ls[k].delta = -8096;
								basey += -8096;
								cloop++;
								goto loop;

							}
							r->l.ls[k].a.delta = deltay;
						}
						else if(deltay >= 8096)
						{
							r->l.ls[k].a.delta = 8095;
							basey += 8095;
							cloop++;
							goto loop;
						}
						else
						{
							r->l.ls[k].a.delta = deltay;
						}
					}
					else if(deltay == 0) /* deltax only */

					{
						r->l.ls[k].a.dmode = DELTAX;
						if(deltax < 0)
						{
							if(deltax < -8096)
							{
								r->l.ls[k].delta = -8096;
								basex += -8096;
								goto loop;

							}
							r->l.ls[k].a.delta = deltax;
						}
						else if(deltax >= 8096)
						{
							r->l.ls[k].a.delta = 8095;
							basex += 8095;
							goto loop;
						}
						else
						{
							r->l.ls[k].a.delta = deltax;
						}
					}
					else	/* deltax, deltay */
					{
						if(((-64 <= deltax) && (deltax <= 63))
							&& (-64 <= deltay) && (deltay <= 63))
						{
							r->l.ls[k].c.dmode = SDELTAXY;
							r->l.ls[k].c.deltax1 = deltax;
							r->l.ls[k].c.deltay1 = deltay;
						}
						else
						{
							/* must be with in limits */
							r->l.ls[k].a.dmode = DELTAXY;
							r->l.ls[k].a.delta = deltay;
							r->l.ls = (union lineseg *)mrealloc((char *)r->l.ls, sizeof (union lineseg) * (++k +1));
							r->l.ls[k].b.delta1 = deltax;
						}
					}
					basex = x;
					basey = y;
				}
				r->l.nsegs = k+1;
		if(q->list == NULL)
		{
			warn("NULL list\n");
			abort();
		}
				insert(q->list, r);
			}
			else if(strcmp(str, "$arc") == 0)
			{
				r = (union unit *) mmalloc(sizeof (struct sarc));
				r->mod.up = NULL;
				q->size++;
				if(sscanf(buf, "%s%ho%hd%hd%hd%hd%hd%hd",
					str, &lev, &r->arc.x, &r->arc.y,
					&r->arc.x1, &r->arc.y1,
					&r->arc.cx, &r->arc.cy) != 8)
					goto bad1;
				r->arc.op = ARC;
				r->arc.level = lev;
				insert(q->list, r);
			}
			else if(strcmp(str, "$circle") == 0)
			{
				r = (union unit *) mmalloc(sizeof (struct scir));
				r->mod.up = NULL;
				q->size++;
				if(sscanf(buf, "%s%ho%hd%hd%hd",
					str, &lev, &r->cir.x, &r->cir.y,
					&r->cir.rad) != 5)
					goto bad1;
				r->cir.op = CIRCLE;
				r->cir.level = lev;
				insert(q->list, r);
			}
			else if(strcmp(str, "$str") == 0)
			{
				r = (union unit *) mmalloc(sizeof (struct sstr));
				r->str.up = NULL;
				q->size++;
				if(sscanf(buf, "%s%ho%d%hd%hd%hd%hd",
					str, &lev, &cnt, &r->str.sscale,
					&r->str.x, &r->str.y, &r->str.srot) != 7)
					goto bad1;
				r->str.op = STRING;
				r->str.level = lev;
				r->str.cnt = cnt;
				getc(infile); getc(infile); /* throw away \t's */
				r->str.sp = mmalloc(cnt + 1);
				fgets(r->str.sp, cnt+1, infile);
				getc(infile); /* throw away cr */
				insert(q->list, r);
			}
			else
			{
				r = (union unit *) mmalloc(sizeof (struct smod));
				r->mod.up = NULL;
				r->mod.op = MODULE;
				q->size++;
				if(sscanf(buf, "%s%ho%hd%hd%hd%hd",
					str, &lev,
					&r->mod.x, &r->mod.y,
					&r->mod.mscale, &r->mod.mrot) != 6)
					goto bad1;
				if((pp = lookup(str)) == NULL)
				{
					pp = &symtab[nsyms++];
					strncpy(pp->name, str, NAMESIZ);
					pp->def = 0;
					pp->list = (union unit *)mmalloc(sizeof (struct smod));
					pp->list->mod.up = NULL;
				}
				r->mod.modnum = pp - symtab;
				insert(q->list, r);
			}
		}
		writeout(q);
	}

	for(i = orignsyms;i < nsyms;i++)
		if((symtab[i].def & DEF) == 0)
		{
			fprintf(stderr, "undefined module %.*s\n", NAMESIZ, symtab[i].name);
			oldline();
		}
	fclose(infile);
	oldline();
	return;

  bad1:
	fprintf(stderr, "bad module %.*s line %d\t%s\n", NAMESIZ, q->name, inline, buf);
	oldline();
   bad:
	for(i = orignsyms;i < nsyms;i++)
		deleteincore(1, &symtab[i]);
	nsyms = orignsyms;
	return;
}

/* write a binary type file
   (for faster reading)
 */

#ifdef BINARYFILES
bwritef(fn)
char *fn;
{
	FILE *outfile;

	register struct symbol sp;
	register i;

	if((outfile = fopen(cp, "w")) == NULL)
	{
		perror(cp);
		oldline();
		return;
	}

	for(i = 0; i < nsyms; i++)
		if(symtab[i].def & LIB == 0)
		{
			sp = &symtab[i];
			readin(sp);
			binwrite(sp, outfile);
		}
	if(ferror(outfile))
		warn("write failed\n");
	fclose(outfile);
}

/* read in a binary file
  (much quicker)
 */

bread1(cp, flg)
char *cp;
{
	FILE *infile;

	register struct symbol *sp;

	sp = &symtab[nsyms];

	while(fread((char *)sp, sizeof (struct symbol), 1, infile) != 0)
	{
		sp->list = NULL;
		binread(sp, infile, 1);
		writeout(sp);
	}
	fclose(infile);
}
#endif
