h48119
s 00001/00001/00397
d D 1.3 81/03/04 16:10:42 root 3 2
c change check digit validation for 1981 (-35 and try again)
e
s 00000/00000/00398
d D 1.2 81/01/18 10:55:14 root 2 1
c original from elecvax 18/1/81 no changes....
e
s 00398/00000/00000
d D 1.1 81/01/17 15:19:18 root 1 0
e
u
U
t
T
I 1
#include <local-system>
#include <passwd.h>
#include <stdio.h>
#include <signal.h>

/*	to make new accounts:
**
**		mkacc CLASS [-c] [-o] [-w]
**
**	accepts new members of class CLASS, creating direc. etc, optionally
**		-c	setting new class mask bit on already existant
**			accounts (IFF bit 64 is set, CLEAR MASK FIRST)
**		-o	allows acceptance of OTHER field.
**		-w	NO warnings about invalid names
**
**	NOTE: The password entry templates are COMPILED IN (quick but nasty)
**		and so new class templates must be added with care.....
**
**	All data comes from the compiled-in templates.
**
 */
#define	PROMPT(x)	if(prompt) printf( x)

#define	NCLASS		(CLASSMASKSIZE*BITSINMASK)
#define LOGNAME 100
#define FIRST	50
#define LAST	40
#define OTHERF	100
#define DIREC	100
#define	LOGLENG	7

struct templates
	{
	char	*da_class;
	struct pwent	da_dpw;
	}
	templates[NCLASS] =
	{
	/* the compiled-in templates */
#		include <classincludes.h>
	};

struct pwent tpw;
struct pwent *dp;
char	logname[LOGNAME];
char	first[FIRST];
char	last[LAST];
char	otherf[OTHERF];
char	direc[DIREC];
char	buf[250];
char	prompt, wflag, cflag, oflag, stopf;
char	*class;
char	*dflt = "default";

main(argc, argv)
int argc;
char *argv[];
{
register int	i;
char	ccflag;
int	icnt, size;
char	entflag;
extern stop();

signal(2,stop);
signal(3,stop);
while (argc-- > 1)
	{
	if(**++argv == '-')
		{
		while(*++*argv)
			switch(**argv)
			{
			case 'o':	oflag ++;
					break;
			case 'c':	cflag ++;
					break;
			case 'w':	wflag ++;
					break;
			default:	fprintf(stderr, "mkacc: bad arg\n");
					exit(1);
			}
		}
	else
		{
		if(class == 0)
			{
			class = *argv;
			}
		else
			{
			fprintf(stderr, "mkacc: too many classes\n");
			exit(1);
			}
		}
	}

/* args are now set up */
if(isatty(0) == 1)
	prompt ++;

/* prompts set up */
if(!class)
	class = dflt;

while (!stopf)
{
entflag = 0;
ccflag=0;
settplt();
PROMPT("login name: ");
if(gets(logname))
	{
	for(i=0; logname[i] != '\0'; i++);
	if( wflag==0 )
		if( i != LOGLENG )
			{
			printf(logname);
			printf(" not seven chars !\n");
			}
		  else
			if( badchkdig(logname))
				{
				printf(logname);
				printf(" invalid student number\n");
				}
	tpw.pw_strings[LNAME] = logname;
	size = getpwuid(&tpw, buf, sizeof buf);
	if (size == sizeof buf)
		{
		fprintf(stderr,"mkacc: string buffer too small\n");
		exit(1);
		}

	if(size > 0)
		{
		/* there is an entry */
		entflag++;
		printf(logname);
		printf(" user already exists\n");
		if((!cflag) && prompt)
			{
			/* ask about change */
			fprintf(stderr,"shall I change?\n");
			gets(direc);
			if(*direc == 'y')
				/* yes */
				ccflag = 1;
			 else
				/* no */
				ccflag = 0;
			}
		if(cflag || ccflag)
			{
			setclass();
			printf(logname);
			printf(" user class mask set\n");
			}
		if(updtpwent(&tpw) != 1)
			error(" update failed\n");
		}
	  else
		{
		/* there is no entry */
		while (1)
			{
			icnt = 0;
			PROMPT("family name: ");
			if(gets(last))
				{
				tpw.pw_strings[LASTNAME] = last;
				icnt++;
				}
			  else
				break;
			PROMPT("other names: ");
			if(gets(first))
				{
				tpw.pw_strings[FIRSTNAME] = first;
				icnt++;
				}
			  else
				break;
			if(oflag)
				{
				PROMPT("other information: ");
				if(gets(otherf))
					{
					tpw.pw_strings[OTHER] = otherf;
					icnt++;
					}
				  else
					break;
				}
			break;
			}
		if( (oflag && (icnt != 3)) || ((oflag != 1) && (icnt != 2)) )
			{
			fprintf(stderr,"mkacc: last entry not completed\n");
			exit(1);
			}

		if((strlen(tpw.pw_strings[DIRPATH])+strlen(logname))>(DIREC-2))
			{
			fprintf(stderr,"mkacc: directory path too long\n");
			exit(1);
			}
		  else
			{
			strcpy(direc,tpw.pw_strings[DIRPATH]);
			strcat(direc,logname);
			tpw.pw_strings[DIRPATH] = direc;
			}

		if(addpwent(&tpw) < 0)
			error(" add failed\n");
		mkit();
		}
	if(entflag && (!prompt))
		{
		gets(buf);
		gets(buf);
		if(oflag) gets(buf);
		}
	}
  else
	{
	fprintf(stderr,"mkacc: end\n");
	exit(0);
	}
}
}

mkit()
{
	register int cpid;
	int status;


	if(cpid = fork())
	{
		/* parent */ 
		if(cpid == -1)
		{
			fprintf(stderr,"mkacc: cant fork mkdir\n");
			exit(1);
		}
		else
		{
			wait(&status);
			if(status&0177400)
				error(" mkdir failed\n");
			else
			{
				if(chown(tpw.pw_strings[DIRPATH], tpw.pw_limits.l_uid, tpw.pw_gid) < 0)
					error(" chown failed\n");
			}
		}
	}
	else
	{
		/* child */ 
		execl("/bin/mkdir", "mkdir", tpw.pw_strings[DIRPATH], 0);
		error(" cannot exec mkdir\n");
	}
}

error(s1)
char *s1;
{
fprintf(stderr,"mkacc: ");
fprintf(stderr,logname);
fprintf(stderr, s1);
exit(1);
}

settplt()
{
register int	i;

/*
**	If first time thru, find the struct and point dp at it
**	else, dp is set so zap straight thru.
 */

if(dp == 0)
	for(i=0; i< NCLASS; i++)
		if(strcmp(class, templates[i].da_class) == 0)
			{
			dp = &templates[i].da_dpw;
			break;
			}

if(dp == 0)
	{
	fprintf(stderr,"mkacc: no such class template\n");
	exit(1);
	}

/* now dp points at the template */

tpw.pw_next = dp->pw_next;
tpw.pw_last = dp->pw_last;

tpw.pw_limits.l_uid = dp->pw_limits.l_uid;
tpw.pw_limits.l_flags = dp->pw_limits.l_flags;
tpw.pw_limits.l_shares = dp->pw_limits.l_shares;
tpw.pw_limits.l_nice = dp->pw_limits.l_nice;
tpw.pw_limits.l_dlimit = dp->pw_limits.l_dlimit;
tpw.pw_limits.l_doverflw = dp->pw_limits.l_doverflw;
tpw.pw_limits.l_plimit = dp->pw_limits.l_plimit;
tpw.pw_limits.l_refcount = dp->pw_limits.l_refcount;
tpw.pw_limits.l_mlimit = dp->pw_limits.l_mlimit;
tpw.pw_limits.l_mplimit = dp->pw_limits.l_mplimit;
tpw.pw_limits.l_muse = dp->pw_limits.l_muse;
tpw.pw_limits.l_duse = dp->pw_limits.l_duse;
tpw.pw_limits.l_usage = dp->pw_limits.l_usage;
tpw.pw_limits.l_rate = dp->pw_limits.l_rate;
tpw.pw_limits.l_cost = dp->pw_limits.l_cost;

for(i=0; i<CLASSMASKSIZE; i++)
	tpw.pw_limits.l_cmask[i] = dp->pw_limits.l_cmask[i];

tpw.pw_gid = dp->pw_gid;
#ifdef	TTY_GROUPS
tpw.pw_tmask = dp->pw_tmask;
#endif	TTY_GROUPS
tpw.pw_age = dp->pw_age;
tpw.pw_contime = dp->pw_contime;
tpw.pw_cputime = dp->pw_cputime;
tpw.pw_extime = dp->pw_extime;
tpw.pw_pages = dp->pw_pages;
tpw.pw_pgused = dp->pw_pgused;
#ifdef	TERMBOOK
tpw.pw_tblim = dp->pw_tblim;
tpw.pw_tbrate = dp->pw_tbrate;
#endif	TERMBOOK
tpw.pw_xflags = dp->pw_xflags;
tpw.pw_reason = dp->pw_reason;
tpw.pw_warn = dp->pw_warn;

for(i=0; i<CRYPTLEN; i++)
	tpw.pw_pword[i] = dp->pw_pword[i];

for(i=0; i<PWSLENCNT; i++)
	tpw.pw_strings[i] = dp->pw_strings[i];

/* and thats the lot */
}

setclass()
{
register char	*rn, *rm;
register int i;

if(tpw.pw_limits.l_cmask[CLASSMASKSIZE-1] & 01)
	/* must clear all mask */
	for(i=0; i<CLASSMASKSIZE; i++)
		tpw.pw_limits.l_cmask[i] = 0;

rn = dp->pw_limits.l_cmask;
rm = tpw.pw_limits.l_cmask;

for(i=0; i<CLASSMASKSIZE; i++)
	*rm++ |= *rn++;
}

stop()
{
signal(2,SIG_IGN);
signal(3,SIG_IGN);
stopf++;
}

badchkdig(s)
char *s;
{
register int sum;
register int funny;

funny = 0;
D 3
if((*s == '8') && (*(s+1) == '0')) funny++;
E 3
I 3
if(*s == '8') funny++;
E 3

sum =	7 * (*s++ - '0');
sum +=	6 * (*s++ - '0');
sum +=	5 * (*s++ - '0');
sum +=	4 * (*s++ - '0');
sum +=	3 * (*s++ - '0');
sum +=	2 * (*s++ - '0');
sum +=	1 * (*s - '0');

if((sum % 11) == 0) return(0);

if(funny)
	return((sum - 35) % 11);
else
	return(1);
}
E 1
