/* $Id: main.h,v 1.10 2004/06/20 07:41:46 grog Exp grog $
 *
 * Copyright (c) 2004 by Greg Lehey
 * 
 *  This software is distributed under the so-called ``Berkeley 
 *  License'': 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 
 * This software is provided ``as is'', and any express or implied 
 * warranties, including, but not limited to, the implied warranties of 
 * merchantability and fitness for a particular purpose are disclaimed. 
 * In no event shall Domenick Venezia be liable for any 
 * direct, indirect, incidental, special, exemplary, or consequential 
 * damages (including, but not limited to, procurement of substitute 
 * goods or services; loss of use, data, or profits; or business 
 * interruption) however caused and on any theory of liability, whether 
 * in contract, strict liability, or tort (including negligence or 
 * otherwise) arising in any way out of the use of this software, even if 
 * advised of the possibility of such damage. 
 */

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <unistd.h>
#include <setjmp.h>					    /* XXX */
#include <signal.h>
#include <sys/time.h>
#include "config.h"					    /* configuration variables */

/* This needs to be behind sys/types.h, at least in older FreeBSD. */
#include <grp.h>

#define BUFSIZE	256					    /* length of input buffer */
#define MAXARGS  64					    /* maximum number of tokens */
#define DEFAULT_HISTORYFILE "/var/log/temp_history"	    /* default name for history stuff */
#define DEFAULTRCFILE "/usr/local/share/tempcontrol/.temperaturecontrolrc" /* default rc file */
#define MAXDATETEXT 128					    /* date text in history (far too much) */

extern FILE *infile;					    /* input file */
extern FILE *debugfd;					    /* and debug output file */

/* Heater and cooler on and off times, in monitor.c */

/* The earliest time we can do certain things. */
extern time_t nextheateron;				    /* next time we can turn the heater on */
extern time_t nextcooleron;				    /* next time we can turn the cooler on */

extern time_t nextheateroff;				    /* next time we can turn the heater off */
extern time_t nextcooleroff;				    /* next time we can turn the cooler off */

extern int monitoring;					    /* set when we're in the monitor command */
void timestamp (void);
void setsigs (int);
/* catch SIGINT */
void catchsig (int ignore);
/* catch SIGSEGV and SIGBUS */
void diediedie (int ignore);
/* catch SIGUSR1: dump stae */
void dumpinfo (int ignore);

extern void opendebugfile ();
void dump_state (char *reason);				    /* dump the current monitor state */
void dumpstatechange (char *reason);			    /* and smaller printout */
void dumptempcalcs (char *reason);

extern int doinfodump;					    /* set to dump info while monitoring */
/*
 * Check if we have an rc file, or if we have already read one,
 * whether it has been changed.  If so, read it in.  Return 1 if we
 * read it in, 0 if we don't, including error conditions.
 */
int checkrcfile ();

/* Set relays */
void setrelay (int bits);

#include "parser.h"

#ifdef linux
/*
 * Linux doesn't have strlcpy by default.  I should include the
 * implementation here, but I'm too lazy, so I just ignore the dangers
 * and use strcpy.
 */
size_t strlcpy (char *dst, const char *src, size_t size);
#endif
